/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.TpmBuffer;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMU_SENSITIVE_COMPOSITE;
import tss.tpm.TPM_ALG_ID;
import tss.tpm.UnionFactory;

public class TPMT_SENSITIVE
extends TpmStructure {
    public byte[] authValue;
    public byte[] seedValue;
    public TPMU_SENSITIVE_COMPOSITE sensitive;

    public TPM_ALG_ID sensitiveType() {
        return this.sensitive.GetUnionSelector();
    }

    public TPMT_SENSITIVE() {
    }

    public TPMT_SENSITIVE(byte[] _authValue, byte[] _seedValue, TPMU_SENSITIVE_COMPOSITE _sensitive) {
        this.authValue = _authValue;
        this.seedValue = _seedValue;
        this.sensitive = _sensitive;
    }

    @Override
    public void toTpm(TpmBuffer buf) {
        if (this.sensitive == null) {
            return;
        }
        buf.writeShort(this.sensitive.GetUnionSelector());
        buf.writeSizedByteBuf(this.authValue);
        buf.writeSizedByteBuf(this.seedValue);
        this.sensitive.toTpm(buf);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        TPM_ALG_ID sensitiveType = TPM_ALG_ID.fromTpm(buf);
        this.authValue = buf.readSizedByteBuf();
        this.seedValue = buf.readSizedByteBuf();
        this.sensitive = (TPMU_SENSITIVE_COMPOSITE)UnionFactory.create("TPMU_SENSITIVE_COMPOSITE", sensitiveType);
        this.sensitive.initFromTpm(buf);
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static TPMT_SENSITIVE fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(TPMT_SENSITIVE.class);
    }

    public static TPMT_SENSITIVE fromTpm(byte[] byteBuf) {
        return TPMT_SENSITIVE.fromBytes(byteBuf);
    }

    public static TPMT_SENSITIVE fromTpm(TpmBuffer buf) {
        return buf.createObj(TPMT_SENSITIVE.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPMT_SENSITIVE");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "byte[]", "authValue", this.authValue);
        _p.add(d, "byte[]", "seedValue", this.seedValue);
        _p.add(d, "TPMU_SENSITIVE_COMPOSITE", "sensitive", this.sensitive);
    }
}

