/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.Crypto;
import tss.Helpers;
import tss.TpmBuffer;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMU_SIGNATURE;
import tss.tpm.TPM_ALG_ID;

public class TPMT_HA
extends TpmStructure
implements TPMU_SIGNATURE {
    public TPM_ALG_ID hashAlg;
    public byte[] digest;

    public TPMT_HA() {
        this.hashAlg = TPM_ALG_ID.NULL;
    }

    public TPMT_HA(TPM_ALG_ID _hashAlg, byte[] _digest) {
        this.hashAlg = _hashAlg;
        this.digest = _digest;
    }

    @Override
    public TPM_ALG_ID GetUnionSelector() {
        return TPM_ALG_ID.HMAC;
    }

    @Override
    public void toTpm(TpmBuffer buf) {
        this.hashAlg.toTpm(buf);
        buf.writeByteBuf(this.digest);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.hashAlg = TPM_ALG_ID.fromTpm(buf);
        this.digest = buf.readByteBuf(Crypto.digestSize(this.hashAlg));
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static TPMT_HA fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(TPMT_HA.class);
    }

    public static TPMT_HA fromTpm(byte[] byteBuf) {
        return TPMT_HA.fromBytes(byteBuf);
    }

    public static TPMT_HA fromTpm(TpmBuffer buf) {
        return buf.createObj(TPMT_HA.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPMT_HA");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_ALG_ID", "hashAlg", this.hashAlg);
        _p.add(d, "byte[]", "digest", this.digest);
    }

    public static TPMT_HA fromHashOf(TPM_ALG_ID hashAlg, byte[] data) {
        return new TPMT_HA(hashAlg, Crypto.hash(hashAlg, data));
    }

    public static TPMT_HA fromHashOf(TPM_ALG_ID hashAlg, String s) {
        byte[] buf = s.getBytes();
        return TPMT_HA.fromHashOf(hashAlg, buf);
    }

    public TPMT_HA extend(byte[] x) {
        byte[] t = Helpers.concatenate(this.digest, x);
        this.digest = Crypto.hash(this.hashAlg, t);
        return this;
    }

    public TPMT_HA event(byte[] x) {
        byte[] s = Crypto.hash(this.hashAlg, x);
        byte[] t = Helpers.concatenate(this.digest, s);
        this.digest = Crypto.hash(this.hashAlg, t);
        return this;
    }

    public void reset() {
        this.digest = new byte[Crypto.digestSize(this.hashAlg)];
    }

    public static TPMT_HA zeroHash(TPM_ALG_ID alg) {
        return new TPMT_HA(alg, new byte[Crypto.digestSize(alg)]);
    }
}

