/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.TpmBuffer;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMU_SIGNATURE;
import tss.tpm.TPM_ALG_ID;

public class TPMS_SIGNATURE_ECC
extends TpmStructure
implements TPMU_SIGNATURE {
    public TPM_ALG_ID hash;
    public byte[] signatureR;
    public byte[] signatureS;

    public TPMS_SIGNATURE_ECC() {
        this.hash = TPM_ALG_ID.NULL;
    }

    public TPMS_SIGNATURE_ECC(TPM_ALG_ID _hash, byte[] _signatureR, byte[] _signatureS) {
        this.hash = _hash;
        this.signatureR = _signatureR;
        this.signatureS = _signatureS;
    }

    @Override
    public TPM_ALG_ID GetUnionSelector() {
        return TPM_ALG_ID.ECDSA;
    }

    @Override
    public void toTpm(TpmBuffer buf) {
        this.hash.toTpm(buf);
        buf.writeSizedByteBuf(this.signatureR);
        buf.writeSizedByteBuf(this.signatureS);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.hash = TPM_ALG_ID.fromTpm(buf);
        this.signatureR = buf.readSizedByteBuf();
        this.signatureS = buf.readSizedByteBuf();
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static TPMS_SIGNATURE_ECC fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(TPMS_SIGNATURE_ECC.class);
    }

    public static TPMS_SIGNATURE_ECC fromTpm(byte[] byteBuf) {
        return TPMS_SIGNATURE_ECC.fromBytes(byteBuf);
    }

    public static TPMS_SIGNATURE_ECC fromTpm(TpmBuffer buf) {
        return buf.createObj(TPMS_SIGNATURE_ECC.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPMS_SIGNATURE_ECC");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_ALG_ID", "hash", this.hash);
        _p.add(d, "byte[]", "signatureR", this.signatureR);
        _p.add(d, "byte[]", "signatureS", this.signatureS);
    }
}

