/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.TpmBuffer;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPM_ALG_ID;

public class TPMS_PCR_SELECTION
extends TpmStructure {
    public TPM_ALG_ID hash;
    public byte[] pcrSelect;

    public TPMS_PCR_SELECTION() {
        this.hash = TPM_ALG_ID.NULL;
    }

    public TPMS_PCR_SELECTION(TPM_ALG_ID _hash, byte[] _pcrSelect) {
        this.hash = _hash;
        this.pcrSelect = _pcrSelect;
    }

    @Override
    public void toTpm(TpmBuffer buf) {
        this.hash.toTpm(buf);
        buf.writeSizedByteBuf(this.pcrSelect, 1);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.hash = TPM_ALG_ID.fromTpm(buf);
        this.pcrSelect = buf.readSizedByteBuf(1);
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static TPMS_PCR_SELECTION fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(TPMS_PCR_SELECTION.class);
    }

    public static TPMS_PCR_SELECTION fromTpm(byte[] byteBuf) {
        return TPMS_PCR_SELECTION.fromBytes(byteBuf);
    }

    public static TPMS_PCR_SELECTION fromTpm(TpmBuffer buf) {
        return buf.createObj(TPMS_PCR_SELECTION.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPMS_PCR_SELECTION");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_ALG_ID", "hash", this.hash);
        _p.add(d, "byte[]", "pcrSelect", this.pcrSelect);
    }

    public TPMS_PCR_SELECTION(TPM_ALG_ID pcrAlg, int pcrIndex) {
        this.hash = pcrAlg;
        int sz = 3;
        if (pcrIndex / 8 + 1 > sz) {
            sz = pcrIndex / 8 + 1;
        }
        this.pcrSelect = new byte[sz];
        this.pcrSelect[pcrIndex / 8] = (byte)(1 << pcrIndex % 8);
    }

    public static TPMS_PCR_SELECTION[] CreateSelectionArray(TPM_ALG_ID pcrAlg, int pcrIndex) {
        TPMS_PCR_SELECTION[] arr = new TPMS_PCR_SELECTION[]{new TPMS_PCR_SELECTION(pcrAlg, pcrIndex)};
        return arr;
    }

    public TPMS_PCR_SELECTION(TPM_ALG_ID pcrAlg, int[] pcrIndices) {
        this.hash = pcrAlg;
        int pcrMax = 0;
        int j = 0;
        while (j < pcrIndices.length) {
            if (pcrIndices[j] > pcrMax) {
                pcrMax = pcrIndices[j];
            }
            ++j;
        }
        if (pcrMax < 23) {
            pcrMax = 23;
        }
        this.pcrSelect = new byte[pcrMax / 8 + 1];
        j = 0;
        while (j < pcrIndices.length) {
            int n = pcrIndices[j] / 8;
            this.pcrSelect[n] = (byte)(this.pcrSelect[n] | (byte)(1 << pcrIndices[j] % 8));
            ++j;
        }
    }
}

