/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.TpmBuffer;
import tss.TpmStructure;
import tss.TpmStructurePrinter;

public class TPMS_CONTEXT_DATA
extends TpmStructure {
    public byte[] integrity;
    public byte[] encrypted;

    public TPMS_CONTEXT_DATA() {
    }

    public TPMS_CONTEXT_DATA(byte[] _integrity, byte[] _encrypted) {
        this.integrity = _integrity;
        this.encrypted = _encrypted;
    }

    @Override
    public void toTpm(TpmBuffer buf) {
        buf.writeSizedByteBuf(this.integrity);
        buf.writeByteBuf(this.encrypted);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.integrity = buf.readSizedByteBuf();
        this.encrypted = buf.readByteBuf(buf.getCurStuctRemainingSize());
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static TPMS_CONTEXT_DATA fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(TPMS_CONTEXT_DATA.class);
    }

    public static TPMS_CONTEXT_DATA fromTpm(byte[] byteBuf) {
        return TPMS_CONTEXT_DATA.fromBytes(byteBuf);
    }

    public static TPMS_CONTEXT_DATA fromTpm(TpmBuffer buf) {
        return buf.createObj(TPMS_CONTEXT_DATA.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPMS_CONTEXT_DATA");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "byte[]", "integrity", this.integrity);
        _p.add(d, "byte[]", "encrypted", this.encrypted);
    }
}

