/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.TpmBuffer;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMS_CLOCK_INFO;
import tss.tpm.TPMU_ATTEST;
import tss.tpm.TPM_GENERATED;
import tss.tpm.TPM_ST;
import tss.tpm.UnionFactory;

public class TPMS_ATTEST
extends TpmStructure {
    public TPM_GENERATED magic;
    public byte[] qualifiedSigner;
    public byte[] extraData;
    public TPMS_CLOCK_INFO clockInfo;
    public long firmwareVersion;
    public TPMU_ATTEST attested;

    public TPM_ST type() {
        return this.attested.GetUnionSelector();
    }

    public TPMS_ATTEST() {
    }

    public TPMS_ATTEST(TPM_GENERATED _magic, byte[] _qualifiedSigner, byte[] _extraData, TPMS_CLOCK_INFO _clockInfo, long _firmwareVersion, TPMU_ATTEST _attested) {
        this.magic = _magic;
        this.qualifiedSigner = _qualifiedSigner;
        this.extraData = _extraData;
        this.clockInfo = _clockInfo;
        this.firmwareVersion = _firmwareVersion;
        this.attested = _attested;
    }

    @Override
    public void toTpm(TpmBuffer buf) {
        this.magic.toTpm(buf);
        buf.writeShort(this.attested.GetUnionSelector());
        buf.writeSizedByteBuf(this.qualifiedSigner);
        buf.writeSizedByteBuf(this.extraData);
        this.clockInfo.toTpm(buf);
        buf.writeInt64(this.firmwareVersion);
        this.attested.toTpm(buf);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.magic = TPM_GENERATED.fromTpm(buf);
        TPM_ST type = TPM_ST.fromTpm(buf);
        this.qualifiedSigner = buf.readSizedByteBuf();
        this.extraData = buf.readSizedByteBuf();
        this.clockInfo = TPMS_CLOCK_INFO.fromTpm(buf);
        this.firmwareVersion = buf.readInt64();
        this.attested = (TPMU_ATTEST)UnionFactory.create("TPMU_ATTEST", type);
        this.attested.initFromTpm(buf);
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static TPMS_ATTEST fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(TPMS_ATTEST.class);
    }

    public static TPMS_ATTEST fromTpm(byte[] byteBuf) {
        return TPMS_ATTEST.fromBytes(byteBuf);
    }

    public static TPMS_ATTEST fromTpm(TpmBuffer buf) {
        return buf.createObj(TPMS_ATTEST.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPMS_ATTEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_GENERATED", "magic", this.magic);
        _p.add(d, "byte[]", "qualifiedSigner", this.qualifiedSigner);
        _p.add(d, "byte[]", "extraData", this.extraData);
        _p.add(d, "TPMS_CLOCK_INFO", "clockInfo", this.clockInfo);
        _p.add(d, "long", "firmwareVersion", this.firmwareVersion);
        _p.add(d, "TPMU_ATTEST", "attested", this.attested);
    }
}

