/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.ReqStructure;
import tss.SessEncInfo;
import tss.TpmBuffer;
import tss.TpmStructurePrinter;
import tss.tpm.TPMU_ASYM_SCHEME;
import tss.tpm.TPM_ALG_ID;
import tss.tpm.TPM_HANDLE;
import tss.tpm.UnionFactory;

public class TPM2_RSA_Decrypt_REQUEST
extends ReqStructure {
    public TPM_HANDLE keyHandle;
    public byte[] cipherText;
    public TPMU_ASYM_SCHEME inScheme;
    public byte[] label;

    public TPM_ALG_ID inSchemeScheme() {
        return this.inScheme != null ? this.inScheme.GetUnionSelector() : TPM_ALG_ID.NULL;
    }

    public TPM2_RSA_Decrypt_REQUEST() {
        this.keyHandle = new TPM_HANDLE();
    }

    public TPM2_RSA_Decrypt_REQUEST(TPM_HANDLE _keyHandle, byte[] _cipherText, TPMU_ASYM_SCHEME _inScheme, byte[] _label) {
        this.keyHandle = _keyHandle;
        this.cipherText = _cipherText;
        this.inScheme = _inScheme;
        this.label = _label;
    }

    @Override
    public void toTpm(TpmBuffer buf) {
        buf.writeSizedByteBuf(this.cipherText);
        buf.writeShort(this.inScheme.GetUnionSelector());
        this.inScheme.toTpm(buf);
        buf.writeSizedByteBuf(this.label);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.cipherText = buf.readSizedByteBuf();
        TPM_ALG_ID inSchemeScheme = TPM_ALG_ID.fromTpm(buf);
        this.inScheme = (TPMU_ASYM_SCHEME)UnionFactory.create("TPMU_ASYM_SCHEME", inSchemeScheme);
        this.inScheme.initFromTpm(buf);
        this.label = buf.readSizedByteBuf();
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static TPM2_RSA_Decrypt_REQUEST fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(TPM2_RSA_Decrypt_REQUEST.class);
    }

    public static TPM2_RSA_Decrypt_REQUEST fromTpm(byte[] byteBuf) {
        return TPM2_RSA_Decrypt_REQUEST.fromBytes(byteBuf);
    }

    public static TPM2_RSA_Decrypt_REQUEST fromTpm(TpmBuffer buf) {
        return buf.createObj(TPM2_RSA_Decrypt_REQUEST.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_RSA_Decrypt_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "keyHandle", this.keyHandle);
        _p.add(d, "byte[]", "cipherText", this.cipherText);
        _p.add(d, "TPMU_ASYM_SCHEME", "inScheme", this.inScheme);
        _p.add(d, "byte[]", "label", this.label);
    }

    @Override
    public int numHandles() {
        return 1;
    }

    @Override
    public int numAuthHandles() {
        return 1;
    }

    @Override
    public TPM_HANDLE[] getHandles() {
        return new TPM_HANDLE[]{this.keyHandle};
    }

    @Override
    public SessEncInfo sessEncInfo() {
        return new SessEncInfo(2, 1);
    }
}

