/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.ReqStructure;
import tss.SessEncInfo;
import tss.TpmBuffer;
import tss.TpmStructurePrinter;
import tss.tpm.TPMS_PCR_SELECTION;
import tss.tpm.TPMU_SIG_SCHEME;
import tss.tpm.TPM_ALG_ID;
import tss.tpm.TPM_HANDLE;
import tss.tpm.UnionFactory;

public class TPM2_Quote_REQUEST
extends ReqStructure {
    public TPM_HANDLE signHandle;
    public byte[] qualifyingData;
    public TPMU_SIG_SCHEME inScheme;
    public TPMS_PCR_SELECTION[] PCRselect;

    public TPM_ALG_ID inSchemeScheme() {
        return this.inScheme != null ? this.inScheme.GetUnionSelector() : TPM_ALG_ID.NULL;
    }

    public TPM2_Quote_REQUEST() {
        this.signHandle = new TPM_HANDLE();
    }

    public TPM2_Quote_REQUEST(TPM_HANDLE _signHandle, byte[] _qualifyingData, TPMU_SIG_SCHEME _inScheme, TPMS_PCR_SELECTION[] _PCRselect) {
        this.signHandle = _signHandle;
        this.qualifyingData = _qualifyingData;
        this.inScheme = _inScheme;
        this.PCRselect = _PCRselect;
    }

    @Override
    public void toTpm(TpmBuffer buf) {
        buf.writeSizedByteBuf(this.qualifyingData);
        buf.writeShort(this.inScheme.GetUnionSelector());
        this.inScheme.toTpm(buf);
        buf.writeObjArr(this.PCRselect);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.qualifyingData = buf.readSizedByteBuf();
        TPM_ALG_ID inSchemeScheme = TPM_ALG_ID.fromTpm(buf);
        this.inScheme = (TPMU_SIG_SCHEME)UnionFactory.create("TPMU_SIG_SCHEME", inSchemeScheme);
        this.inScheme.initFromTpm(buf);
        this.PCRselect = (TPMS_PCR_SELECTION[])buf.readObjArr(TPMS_PCR_SELECTION.class);
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static TPM2_Quote_REQUEST fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(TPM2_Quote_REQUEST.class);
    }

    public static TPM2_Quote_REQUEST fromTpm(byte[] byteBuf) {
        return TPM2_Quote_REQUEST.fromBytes(byteBuf);
    }

    public static TPM2_Quote_REQUEST fromTpm(TpmBuffer buf) {
        return buf.createObj(TPM2_Quote_REQUEST.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_Quote_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "signHandle", this.signHandle);
        _p.add(d, "byte[]", "qualifyingData", this.qualifyingData);
        _p.add(d, "TPMU_SIG_SCHEME", "inScheme", this.inScheme);
        _p.add(d, "TPMS_PCR_SELECTION[]", "PCRselect", this.PCRselect);
    }

    @Override
    public int numHandles() {
        return 1;
    }

    @Override
    public int numAuthHandles() {
        return 1;
    }

    @Override
    public TPM_HANDLE[] getHandles() {
        return new TPM_HANDLE[]{this.signHandle};
    }

    @Override
    public SessEncInfo sessEncInfo() {
        return new SessEncInfo(2, 1);
    }
}

