/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.ReqStructure;
import tss.SessEncInfo;
import tss.TpmBuffer;
import tss.TpmStructurePrinter;
import tss.tpm.TPM_EO;
import tss.tpm.TPM_HANDLE;

public class TPM2_PolicyNV_REQUEST
extends ReqStructure {
    public TPM_HANDLE authHandle;
    public TPM_HANDLE nvIndex;
    public TPM_HANDLE policySession;
    public byte[] operandB;
    public int offset;
    public TPM_EO operation;

    public TPM2_PolicyNV_REQUEST() {
        this.authHandle = new TPM_HANDLE();
        this.nvIndex = new TPM_HANDLE();
        this.policySession = new TPM_HANDLE();
    }

    public TPM2_PolicyNV_REQUEST(TPM_HANDLE _authHandle, TPM_HANDLE _nvIndex, TPM_HANDLE _policySession, byte[] _operandB, int _offset, TPM_EO _operation) {
        this.authHandle = _authHandle;
        this.nvIndex = _nvIndex;
        this.policySession = _policySession;
        this.operandB = _operandB;
        this.offset = _offset;
        this.operation = _operation;
    }

    @Override
    public void toTpm(TpmBuffer buf) {
        buf.writeSizedByteBuf(this.operandB);
        buf.writeShort(this.offset);
        this.operation.toTpm(buf);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.operandB = buf.readSizedByteBuf();
        this.offset = buf.readShort();
        this.operation = TPM_EO.fromTpm(buf);
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static TPM2_PolicyNV_REQUEST fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(TPM2_PolicyNV_REQUEST.class);
    }

    public static TPM2_PolicyNV_REQUEST fromTpm(byte[] byteBuf) {
        return TPM2_PolicyNV_REQUEST.fromBytes(byteBuf);
    }

    public static TPM2_PolicyNV_REQUEST fromTpm(TpmBuffer buf) {
        return buf.createObj(TPM2_PolicyNV_REQUEST.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_PolicyNV_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "authHandle", this.authHandle);
        _p.add(d, "TPM_HANDLE", "nvIndex", this.nvIndex);
        _p.add(d, "TPM_HANDLE", "policySession", this.policySession);
        _p.add(d, "byte[]", "operandB", this.operandB);
        _p.add(d, "int", "offset", this.offset);
        _p.add(d, "TPM_EO", "operation", this.operation);
    }

    @Override
    public int numHandles() {
        return 3;
    }

    @Override
    public int numAuthHandles() {
        return 1;
    }

    @Override
    public TPM_HANDLE[] getHandles() {
        return new TPM_HANDLE[]{this.authHandle, this.nvIndex, this.policySession};
    }

    @Override
    public SessEncInfo sessEncInfo() {
        return new SessEncInfo(2, 1);
    }
}

