/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.ReqStructure;
import tss.SessEncInfo;
import tss.TpmBuffer;
import tss.TpmStructurePrinter;
import tss.tpm.TPMU_SIG_SCHEME;
import tss.tpm.TPM_ALG_ID;
import tss.tpm.TPM_HANDLE;
import tss.tpm.UnionFactory;

public class TPM2_NV_Certify_REQUEST
extends ReqStructure {
    public TPM_HANDLE signHandle;
    public TPM_HANDLE authHandle;
    public TPM_HANDLE nvIndex;
    public byte[] qualifyingData;
    public TPMU_SIG_SCHEME inScheme;
    public int size;
    public int offset;

    public TPM_ALG_ID inSchemeScheme() {
        return this.inScheme != null ? this.inScheme.GetUnionSelector() : TPM_ALG_ID.NULL;
    }

    public TPM2_NV_Certify_REQUEST() {
        this.signHandle = new TPM_HANDLE();
        this.authHandle = new TPM_HANDLE();
        this.nvIndex = new TPM_HANDLE();
    }

    public TPM2_NV_Certify_REQUEST(TPM_HANDLE _signHandle, TPM_HANDLE _authHandle, TPM_HANDLE _nvIndex, byte[] _qualifyingData, TPMU_SIG_SCHEME _inScheme, int _size, int _offset) {
        this.signHandle = _signHandle;
        this.authHandle = _authHandle;
        this.nvIndex = _nvIndex;
        this.qualifyingData = _qualifyingData;
        this.inScheme = _inScheme;
        this.size = _size;
        this.offset = _offset;
    }

    @Override
    public void toTpm(TpmBuffer buf) {
        buf.writeSizedByteBuf(this.qualifyingData);
        buf.writeShort(this.inScheme.GetUnionSelector());
        this.inScheme.toTpm(buf);
        buf.writeShort(this.size);
        buf.writeShort(this.offset);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.qualifyingData = buf.readSizedByteBuf();
        TPM_ALG_ID inSchemeScheme = TPM_ALG_ID.fromTpm(buf);
        this.inScheme = (TPMU_SIG_SCHEME)UnionFactory.create("TPMU_SIG_SCHEME", inSchemeScheme);
        this.inScheme.initFromTpm(buf);
        this.size = buf.readShort();
        this.offset = buf.readShort();
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static TPM2_NV_Certify_REQUEST fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(TPM2_NV_Certify_REQUEST.class);
    }

    public static TPM2_NV_Certify_REQUEST fromTpm(byte[] byteBuf) {
        return TPM2_NV_Certify_REQUEST.fromBytes(byteBuf);
    }

    public static TPM2_NV_Certify_REQUEST fromTpm(TpmBuffer buf) {
        return buf.createObj(TPM2_NV_Certify_REQUEST.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_NV_Certify_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "signHandle", this.signHandle);
        _p.add(d, "TPM_HANDLE", "authHandle", this.authHandle);
        _p.add(d, "TPM_HANDLE", "nvIndex", this.nvIndex);
        _p.add(d, "byte[]", "qualifyingData", this.qualifyingData);
        _p.add(d, "TPMU_SIG_SCHEME", "inScheme", this.inScheme);
        _p.add(d, "int", "size", this.size);
        _p.add(d, "int", "offset", this.offset);
    }

    @Override
    public int numHandles() {
        return 3;
    }

    @Override
    public int numAuthHandles() {
        return 2;
    }

    @Override
    public TPM_HANDLE[] getHandles() {
        return new TPM_HANDLE[]{this.signHandle, this.authHandle, this.nvIndex};
    }

    @Override
    public SessEncInfo sessEncInfo() {
        return new SessEncInfo(2, 1);
    }
}

