/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.ReqStructure;
import tss.TpmBuffer;
import tss.TpmStructurePrinter;
import tss.tpm.TPM_ALG_ID;
import tss.tpm.TPM_HANDLE;

public class TPM2_EncryptDecrypt_REQUEST
extends ReqStructure {
    public TPM_HANDLE keyHandle;
    public byte decrypt;
    public TPM_ALG_ID mode;
    public byte[] ivIn;
    public byte[] inData;

    public TPM2_EncryptDecrypt_REQUEST() {
        this.keyHandle = new TPM_HANDLE();
        this.mode = TPM_ALG_ID.NULL;
    }

    public TPM2_EncryptDecrypt_REQUEST(TPM_HANDLE _keyHandle, byte _decrypt, TPM_ALG_ID _mode, byte[] _ivIn, byte[] _inData) {
        this.keyHandle = _keyHandle;
        this.decrypt = _decrypt;
        this.mode = _mode;
        this.ivIn = _ivIn;
        this.inData = _inData;
    }

    @Override
    public void toTpm(TpmBuffer buf) {
        buf.writeByte(this.decrypt);
        this.mode.toTpm(buf);
        buf.writeSizedByteBuf(this.ivIn);
        buf.writeSizedByteBuf(this.inData);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.decrypt = buf.readByte();
        this.mode = TPM_ALG_ID.fromTpm(buf);
        this.ivIn = buf.readSizedByteBuf();
        this.inData = buf.readSizedByteBuf();
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static TPM2_EncryptDecrypt_REQUEST fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(TPM2_EncryptDecrypt_REQUEST.class);
    }

    public static TPM2_EncryptDecrypt_REQUEST fromTpm(byte[] byteBuf) {
        return TPM2_EncryptDecrypt_REQUEST.fromBytes(byteBuf);
    }

    public static TPM2_EncryptDecrypt_REQUEST fromTpm(TpmBuffer buf) {
        return buf.createObj(TPM2_EncryptDecrypt_REQUEST.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_EncryptDecrypt_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "keyHandle", this.keyHandle);
        _p.add(d, "byte", "decrypt", this.decrypt);
        _p.add(d, "TPM_ALG_ID", "mode", this.mode);
        _p.add(d, "byte[]", "ivIn", this.ivIn);
        _p.add(d, "byte[]", "inData", this.inData);
    }

    @Override
    public int numHandles() {
        return 1;
    }

    @Override
    public int numAuthHandles() {
        return 1;
    }

    @Override
    public TPM_HANDLE[] getHandles() {
        return new TPM_HANDLE[]{this.keyHandle};
    }
}

