/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.ReqStructure;
import tss.SessEncInfo;
import tss.TpmBuffer;
import tss.TpmStructurePrinter;
import tss.tpm.TPM_ALG_ID;
import tss.tpm.TPM_HANDLE;

public class TPM2_EncryptDecrypt2_REQUEST
extends ReqStructure {
    public TPM_HANDLE keyHandle;
    public byte[] inData;
    public byte decrypt;
    public TPM_ALG_ID mode;
    public byte[] ivIn;

    public TPM2_EncryptDecrypt2_REQUEST() {
        this.keyHandle = new TPM_HANDLE();
        this.mode = TPM_ALG_ID.NULL;
    }

    public TPM2_EncryptDecrypt2_REQUEST(TPM_HANDLE _keyHandle, byte[] _inData, byte _decrypt, TPM_ALG_ID _mode, byte[] _ivIn) {
        this.keyHandle = _keyHandle;
        this.inData = _inData;
        this.decrypt = _decrypt;
        this.mode = _mode;
        this.ivIn = _ivIn;
    }

    @Override
    public void toTpm(TpmBuffer buf) {
        buf.writeSizedByteBuf(this.inData);
        buf.writeByte(this.decrypt);
        this.mode.toTpm(buf);
        buf.writeSizedByteBuf(this.ivIn);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.inData = buf.readSizedByteBuf();
        this.decrypt = buf.readByte();
        this.mode = TPM_ALG_ID.fromTpm(buf);
        this.ivIn = buf.readSizedByteBuf();
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static TPM2_EncryptDecrypt2_REQUEST fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(TPM2_EncryptDecrypt2_REQUEST.class);
    }

    public static TPM2_EncryptDecrypt2_REQUEST fromTpm(byte[] byteBuf) {
        return TPM2_EncryptDecrypt2_REQUEST.fromBytes(byteBuf);
    }

    public static TPM2_EncryptDecrypt2_REQUEST fromTpm(TpmBuffer buf) {
        return buf.createObj(TPM2_EncryptDecrypt2_REQUEST.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_EncryptDecrypt2_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "keyHandle", this.keyHandle);
        _p.add(d, "byte[]", "inData", this.inData);
        _p.add(d, "byte", "decrypt", this.decrypt);
        _p.add(d, "TPM_ALG_ID", "mode", this.mode);
        _p.add(d, "byte[]", "ivIn", this.ivIn);
    }

    @Override
    public int numHandles() {
        return 1;
    }

    @Override
    public int numAuthHandles() {
        return 1;
    }

    @Override
    public TPM_HANDLE[] getHandles() {
        return new TPM_HANDLE[]{this.keyHandle};
    }

    @Override
    public SessEncInfo sessEncInfo() {
        return new SessEncInfo(2, 1);
    }
}

