/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.ReqStructure;
import tss.SessEncInfo;
import tss.TpmBuffer;
import tss.TpmStructurePrinter;
import tss.tpm.TPMS_PCR_SELECTION;
import tss.tpm.TPMS_SENSITIVE_CREATE;
import tss.tpm.TPMT_PUBLIC;
import tss.tpm.TPM_HANDLE;

public class TPM2_Create_REQUEST
extends ReqStructure {
    public TPM_HANDLE parentHandle;
    public TPMS_SENSITIVE_CREATE inSensitive;
    public TPMT_PUBLIC inPublic;
    public byte[] outsideInfo;
    public TPMS_PCR_SELECTION[] creationPCR;

    public TPM2_Create_REQUEST() {
        this.parentHandle = new TPM_HANDLE();
    }

    public TPM2_Create_REQUEST(TPM_HANDLE _parentHandle, TPMS_SENSITIVE_CREATE _inSensitive, TPMT_PUBLIC _inPublic, byte[] _outsideInfo, TPMS_PCR_SELECTION[] _creationPCR) {
        this.parentHandle = _parentHandle;
        this.inSensitive = _inSensitive;
        this.inPublic = _inPublic;
        this.outsideInfo = _outsideInfo;
        this.creationPCR = _creationPCR;
    }

    @Override
    public void toTpm(TpmBuffer buf) {
        buf.writeSizedObj(this.inSensitive);
        buf.writeSizedObj(this.inPublic);
        buf.writeSizedByteBuf(this.outsideInfo);
        buf.writeObjArr(this.creationPCR);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.inSensitive = buf.createSizedObj(TPMS_SENSITIVE_CREATE.class);
        this.inPublic = buf.createSizedObj(TPMT_PUBLIC.class);
        this.outsideInfo = buf.readSizedByteBuf();
        this.creationPCR = (TPMS_PCR_SELECTION[])buf.readObjArr(TPMS_PCR_SELECTION.class);
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static TPM2_Create_REQUEST fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(TPM2_Create_REQUEST.class);
    }

    public static TPM2_Create_REQUEST fromTpm(byte[] byteBuf) {
        return TPM2_Create_REQUEST.fromBytes(byteBuf);
    }

    public static TPM2_Create_REQUEST fromTpm(TpmBuffer buf) {
        return buf.createObj(TPM2_Create_REQUEST.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_Create_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "parentHandle", this.parentHandle);
        _p.add(d, "TPMS_SENSITIVE_CREATE", "inSensitive", this.inSensitive);
        _p.add(d, "TPMT_PUBLIC", "inPublic", this.inPublic);
        _p.add(d, "byte[]", "outsideInfo", this.outsideInfo);
        _p.add(d, "TPMS_PCR_SELECTION[]", "creationPCR", this.creationPCR);
    }

    @Override
    public int numHandles() {
        return 1;
    }

    @Override
    public int numAuthHandles() {
        return 1;
    }

    @Override
    public TPM_HANDLE[] getHandles() {
        return new TPM_HANDLE[]{this.parentHandle};
    }

    @Override
    public SessEncInfo sessEncInfo() {
        return new SessEncInfo(2, 1);
    }
}

