/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.RespStructure;
import tss.SessEncInfo;
import tss.TpmBuffer;
import tss.TpmStructurePrinter;
import tss.tpm.TPMS_ID_OBJECT;

public class MakeCredentialResponse
extends RespStructure {
    public TPMS_ID_OBJECT credentialBlob;
    public byte[] secret;

    @Override
    public void toTpm(TpmBuffer buf) {
        buf.writeSizedObj(this.credentialBlob);
        buf.writeSizedByteBuf(this.secret);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.credentialBlob = buf.createSizedObj(TPMS_ID_OBJECT.class);
        this.secret = buf.readSizedByteBuf();
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static MakeCredentialResponse fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(MakeCredentialResponse.class);
    }

    public static MakeCredentialResponse fromTpm(byte[] byteBuf) {
        return MakeCredentialResponse.fromBytes(byteBuf);
    }

    public static MakeCredentialResponse fromTpm(TpmBuffer buf) {
        return buf.createObj(MakeCredentialResponse.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("MakeCredentialResponse");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPMS_ID_OBJECT", "credentialBlob", this.credentialBlob);
        _p.add(d, "byte[]", "secret", this.secret);
    }

    @Override
    public SessEncInfo sessEncInfo() {
        return new SessEncInfo(2, 1);
    }
}

