/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.RespStructure;
import tss.TpmBuffer;
import tss.TpmStructurePrinter;
import tss.tpm.TPMU_CAPABILITIES;
import tss.tpm.TPM_CAP;
import tss.tpm.UnionFactory;

public class GetCapabilityResponse
extends RespStructure {
    public byte moreData;
    public TPMU_CAPABILITIES capabilityData;

    public TPM_CAP capabilityDataCapability() {
        return this.capabilityData.GetUnionSelector();
    }

    @Override
    public void toTpm(TpmBuffer buf) {
        buf.writeByte(this.moreData);
        buf.writeInt(this.capabilityData.GetUnionSelector());
        this.capabilityData.toTpm(buf);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.moreData = buf.readByte();
        TPM_CAP capabilityDataCapability = TPM_CAP.fromTpm(buf);
        this.capabilityData = (TPMU_CAPABILITIES)UnionFactory.create("TPMU_CAPABILITIES", capabilityDataCapability);
        this.capabilityData.initFromTpm(buf);
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static GetCapabilityResponse fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(GetCapabilityResponse.class);
    }

    public static GetCapabilityResponse fromTpm(byte[] byteBuf) {
        return GetCapabilityResponse.fromBytes(byteBuf);
    }

    public static GetCapabilityResponse fromTpm(TpmBuffer buf) {
        return buf.createObj(GetCapabilityResponse.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("GetCapabilityResponse");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "byte", "moreData", this.moreData);
        _p.add(d, "TPMU_CAPABILITIES", "capabilityData", this.capabilityData);
    }
}

