/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.RespStructure;
import tss.TpmBuffer;
import tss.TpmStructurePrinter;
import tss.tpm.TPM2B_PRIVATE;
import tss.tpm.TPMS_CREATION_DATA;
import tss.tpm.TPMT_PUBLIC;
import tss.tpm.TPMT_TK_CREATION;

public class CreateResponse
extends RespStructure {
    public TPM2B_PRIVATE outPrivate;
    public TPMT_PUBLIC outPublic;
    public TPMS_CREATION_DATA creationData;
    public byte[] creationHash;
    public TPMT_TK_CREATION creationTicket;

    @Override
    public void toTpm(TpmBuffer buf) {
        this.outPrivate.toTpm(buf);
        buf.writeSizedObj(this.outPublic);
        buf.writeSizedObj(this.creationData);
        buf.writeSizedByteBuf(this.creationHash);
        this.creationTicket.toTpm(buf);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.outPrivate = TPM2B_PRIVATE.fromTpm(buf);
        this.outPublic = buf.createSizedObj(TPMT_PUBLIC.class);
        this.creationData = buf.createSizedObj(TPMS_CREATION_DATA.class);
        this.creationHash = buf.readSizedByteBuf();
        this.creationTicket = TPMT_TK_CREATION.fromTpm(buf);
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static CreateResponse fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(CreateResponse.class);
    }

    public static CreateResponse fromTpm(byte[] byteBuf) {
        return CreateResponse.fromBytes(byteBuf);
    }

    public static CreateResponse fromTpm(TpmBuffer buf) {
        return buf.createObj(CreateResponse.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("CreateResponse");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM2B_PRIVATE", "outPrivate", this.outPrivate);
        _p.add(d, "TPMT_PUBLIC", "outPublic", this.outPublic);
        _p.add(d, "TPMS_CREATION_DATA", "creationData", this.creationData);
        _p.add(d, "byte[]", "creationHash", this.creationHash);
        _p.add(d, "TPMT_TK_CREATION", "creationTicket", this.creationTicket);
    }
}

