/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.RespStructure;
import tss.TpmBuffer;
import tss.TpmStructurePrinter;
import tss.tpm.TPM2B_PRIVATE;
import tss.tpm.TPMT_PUBLIC;
import tss.tpm.TPM_HANDLE;

public class CreateLoadedResponse
extends RespStructure {
    public TPM_HANDLE handle = new TPM_HANDLE();
    public TPM2B_PRIVATE outPrivate;
    public TPMT_PUBLIC outPublic;
    public byte[] name;

    @Override
    public void toTpm(TpmBuffer buf) {
        this.outPrivate.toTpm(buf);
        buf.writeSizedObj(this.outPublic);
        buf.writeSizedByteBuf(this.name);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.outPrivate = TPM2B_PRIVATE.fromTpm(buf);
        this.outPublic = buf.createSizedObj(TPMT_PUBLIC.class);
        this.name = buf.readSizedByteBuf();
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static CreateLoadedResponse fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(CreateLoadedResponse.class);
    }

    public static CreateLoadedResponse fromTpm(byte[] byteBuf) {
        return CreateLoadedResponse.fromBytes(byteBuf);
    }

    public static CreateLoadedResponse fromTpm(TpmBuffer buf) {
        return buf.createObj(CreateLoadedResponse.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("CreateLoadedResponse");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "handle", this.handle);
        _p.add(d, "TPM2B_PRIVATE", "outPrivate", this.outPrivate);
        _p.add(d, "TPMT_PUBLIC", "outPublic", this.outPublic);
        _p.add(d, "byte[]", "name", this.name);
    }

    @Override
    public int numHandles() {
        return 1;
    }

    @Override
    public TPM_HANDLE getHandle() {
        return this.handle;
    }

    @Override
    public void setHandle(TPM_HANDLE h) {
        this.handle = h;
    }
}

