/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.TpmBuffer;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPM_CC;
import tss.tpm.TPM_ST;

public class CommandHeader
extends TpmStructure {
    public TPM_ST Tag;
    public int CommandSize;
    public TPM_CC CommandCode;

    public CommandHeader() {
    }

    public CommandHeader(TPM_ST _Tag, int _CommandSize, TPM_CC _CommandCode) {
        this.Tag = _Tag;
        this.CommandSize = _CommandSize;
        this.CommandCode = _CommandCode;
    }

    @Override
    public void toTpm(TpmBuffer buf) {
        this.Tag.toTpm(buf);
        buf.writeInt(this.CommandSize);
        this.CommandCode.toTpm(buf);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.Tag = TPM_ST.fromTpm(buf);
        this.CommandSize = buf.readInt();
        this.CommandCode = TPM_CC.fromTpm(buf);
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static CommandHeader fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(CommandHeader.class);
    }

    public static CommandHeader fromTpm(byte[] byteBuf) {
        return CommandHeader.fromBytes(byteBuf);
    }

    public static CommandHeader fromTpm(TpmBuffer buf) {
        return buf.createObj(CommandHeader.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("CommandHeader");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_ST", "Tag", this.Tag);
        _p.add(d, "int", "CommandSize", this.CommandSize);
        _p.add(d, "TPM_CC", "CommandCode", this.CommandCode);
    }
}

