/*
 * Decompiled with CFR 0.152.
 */
package tss;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.TreeMap;
import tss.Helpers;
import tss.TpmBuffer;
import tss.TpmMarshaller;

public abstract class TpmEnum<T extends TpmEnum<T>>
implements TpmMarshaller {
    protected int Value;
    protected Enum<?> NameAsEnum;
    protected String Name;

    protected abstract int wireSize();

    protected TpmEnum(int value, Enum<?> nameAsEnum, ValueMap<T> values) {
        this.Value = value;
        if (nameAsEnum != null) {
            this.Name = nameAsEnum.toString();
            this.NameAsEnum = nameAsEnum;
            if (values != null) {
                values.put(value, this);
            }
        }
    }

    protected TpmEnum(int value, ValueMap<T> values) {
        this.Value = value;
        if (values.containsKey(value)) {
            TpmEnum v = (TpmEnum)values.get(value);
            this.Name = v.Name;
            this.NameAsEnum = v.NameAsEnum;
        } else {
            this.Name = Integer.toHexString(value);
        }
    }

    protected static <T extends TpmEnum<T>> T fromInt(int value, ValueMap<T> values, Class<T> cls) {
        if (values.containsKey(value)) {
            return (T)((TpmEnum)values.get(value));
        }
        Constructor<T> ctor = null;
        try {
            ctor = cls.getConstructor(Integer.TYPE);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
        if (ctor == null) {
            return null;
        }
        TpmEnum newEnum = null;
        try {
            newEnum = (TpmEnum)ctor.newInstance(value);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException exception) {
            // empty catch block
        }
        return (T)newEnum;
    }

    protected static <T extends TpmEnum<T>> T fromTpm(byte[] buf, ValueMap<T> values, Class<T> cls) {
        int value = Helpers.netToHost(buf);
        return TpmEnum.fromInt(value, values, cls);
    }

    protected static <T extends TpmEnum<T>> T fromTpm(TpmBuffer buf, ValueMap<T> values, Class<T> cls) {
        int value = (int)buf.readNum(((TpmEnum)values.firstEntry().getValue()).wireSize());
        return TpmEnum.fromInt(value, values, cls);
    }

    public int toInt() {
        return this.Value;
    }

    @Override
    public void toTpm(TpmBuffer buf) {
        buf.writeNum(this.Value, this.wireSize());
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.Value = (int)buf.readNum(this.wireSize());
    }

    public byte[] toBytes() {
        TpmBuffer buf = new TpmBuffer(this.wireSize());
        buf.writeNum(this.Value, this.wireSize());
        return buf.trim();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass().isInstance(obj)) {
            return this.Value == ((TpmEnum)obj).Value;
        }
        return false;
    }

    public int hashCode() {
        return this.Value;
    }

    public String toString() {
        return "{" + this.name() + "}";
    }

    public String name() {
        return this.Name;
    }

    public String toStringVerbose() {
        return String.valueOf(this.getClass().getSimpleName()) + "." + this.Name + " (" + Integer.toString(this.Value) + ", 0x" + Integer.toHexString(this.Value) + ")";
    }

    protected static class ValueMap<T extends TpmEnum<T>>
    extends TreeMap<Integer, T> {
    }
}

