/*
 * Decompiled with CFR 0.152.
 */
package samples;

import tss.Crypto;
import tss.Helpers;
import tss.Tpm;
import tss.TpmBuffer;
import tss.tpm.CreatePrimaryResponse;
import tss.tpm.DuplicateResponse;
import tss.tpm.MakeCredentialResponse;
import tss.tpm.TPM2B_DIGEST;
import tss.tpm.TPM2B_DIGEST_KEYEDHASH;
import tss.tpm.TPM2B_PUBLIC;
import tss.tpm.TPMA_OBJECT;
import tss.tpm.TPMS_KEYEDHASH_PARMS;
import tss.tpm.TPMS_PCR_SELECTION;
import tss.tpm.TPMS_SCHEME_HMAC;
import tss.tpm.TPMS_SENSITIVE_CREATE;
import tss.tpm.TPMS_SYMCIPHER_PARMS;
import tss.tpm.TPMT_PUBLIC;
import tss.tpm.TPMT_SYM_DEF;
import tss.tpm.TPMT_SYM_DEF_OBJECT;
import tss.tpm.TPM_ALG_ID;
import tss.tpm.TPM_CC;
import tss.tpm.TPM_HANDLE;
import tss.tpm.TPM_RC;
import tss.tpm.TPM_RH;
import tss.tpm.TPM_SE;

public class DrsServer {
    static TPMT_PUBLIC IdKeyTemplate = null;
    static TPMS_SENSITIVE_CREATE IdKeySens = null;

    public static int VerifyIdSignature(Tpm tpm, byte[] data, byte[] sig) {
        byte[] hmac = Crypto.hmac(TPM_ALG_ID.SHA256, DrsServer.IdKeySens.data, data);
        return (Helpers.arraysAreEqual(sig, hmac) ? TPM_RC.SUCCESS : TPM_RC.SIGNATURE).toInt();
    }

    public static int GetActivationBlob2(Tpm tpm, byte[] ekPubBlob, int ekPubSize, byte[] srkPubBlob, int srkPubSize, byte[] actBlobBuffer, int blobBufCapacity) {
        TPMT_PUBLIC ekPub = TPM2B_PUBLIC.fromBytes((byte[])ekPubBlob).publicArea;
        TPMT_PUBLIC srkPub = TPM2B_PUBLIC.fromBytes((byte[])srkPubBlob).publicArea;
        TPM_HANDLE sess = tpm.StartAuthSession((TPM_HANDLE)TPM_HANDLE.NULL, (TPM_HANDLE)TPM_HANDLE.NULL, (byte[])Helpers.RandomBytes((int)20), (byte[])new byte[0], (TPM_SE)TPM_SE.POLICY, (TPMT_SYM_DEF)new TPMT_SYM_DEF((TPM_ALG_ID)TPM_ALG_ID.NULL, (int)0, (TPM_ALG_ID)TPM_ALG_ID.NULL), (TPM_ALG_ID)TPM_ALG_ID.SHA256).handle;
        tpm.PolicyCommandCode(sess, TPM_CC.Duplicate);
        byte[] dupPolicyDigest = tpm.PolicyGetDigest(sess);
        IdKeyTemplate = new TPMT_PUBLIC(TPM_ALG_ID.SHA256, new TPMA_OBJECT(TPMA_OBJECT.sign, TPMA_OBJECT.userWithAuth, TPMA_OBJECT.noDA), dupPolicyDigest, new TPMS_KEYEDHASH_PARMS(new TPMS_SCHEME_HMAC(TPM_ALG_ID.SHA256)), new TPM2B_DIGEST_KEYEDHASH());
        byte[] keyBytes = Helpers.RandomBytes(32);
        IdKeySens = new TPMS_SENSITIVE_CREATE(new byte[0], keyBytes);
        CreatePrimaryResponse idKey = tpm.CreatePrimary(TPM_HANDLE.from(TPM_RH.OWNER), IdKeySens, IdKeyTemplate, new byte[0], new TPMS_PCR_SELECTION[0]);
        TPM_HANDLE srkPubHandle = tpm.LoadExternal(null, srkPub, TPM_HANDLE.from(TPM_RH.OWNER));
        TPMT_SYM_DEF_OBJECT symWrapperDef = new TPMT_SYM_DEF_OBJECT(TPM_ALG_ID.AES, 128, TPM_ALG_ID.CFB);
        DuplicateResponse dupResp = tpm._withSession(sess).Duplicate(idKey.handle, srkPubHandle, new byte[0], symWrapperDef);
        tpm.FlushContext(srkPubHandle);
        TPM_HANDLE ekPubHandle = tpm.LoadExternal(null, ekPub, TPM_HANDLE.from(TPM_RH.ENDORSEMENT));
        MakeCredentialResponse cred = tpm.MakeCredential(ekPubHandle, dupResp.encryptionKeyOut, srkPub.getName());
        tpm.FlushContext(ekPubHandle);
        tpm.FlushContext(idKey.handle);
        tpm.FlushContext(sess);
        TPMT_PUBLIC symWrapperTemplate = new TPMT_PUBLIC(TPM_ALG_ID.SHA256, new TPMA_OBJECT(TPMA_OBJECT.decrypt, TPMA_OBJECT.encrypt, TPMA_OBJECT.userWithAuth), new byte[0], new TPMS_SYMCIPHER_PARMS(symWrapperDef), new TPM2B_DIGEST());
        TPMS_SENSITIVE_CREATE sens = new TPMS_SENSITIVE_CREATE(new byte[0], dupResp.encryptionKeyOut);
        TPM_HANDLE symWrapperHandle = tpm.CreatePrimary((TPM_HANDLE)TPM_HANDLE.from((TPM_RH)TPM_RH.OWNER), (TPMS_SENSITIVE_CREATE)sens, (TPMT_PUBLIC)symWrapperTemplate, (byte[])new byte[0], (TPMS_PCR_SELECTION[])new TPMS_PCR_SELECTION[0]).handle;
        byte[] uriData = "http://my.test.url/TestDeviceID=F4ED90771DAA7C0B3230FF675DF8A61104AE7C8BB0093FD6A".getBytes();
        byte[] iv = new byte[dupResp.encryptionKeyOut.length];
        byte[] encryptedUri = tpm.EncryptDecrypt((TPM_HANDLE)symWrapperHandle, (byte)0, (TPM_ALG_ID)TPM_ALG_ID.CFB, (byte[])iv, (byte[])uriData).outData;
        tpm.FlushContext(symWrapperHandle);
        TpmBuffer actBlob = new TpmBuffer();
        byte[] credBlob = cred.credentialBlob.toBytes();
        actBlob.writeShort(credBlob.length);
        actBlob.writeByteBuf(credBlob);
        actBlob.writeShort(cred.secret.length);
        actBlob.writeByteBuf(cred.secret);
        dupResp.duplicate.toTpm(actBlob);
        actBlob.writeShort(dupResp.outSymSeed.length);
        actBlob.writeByteBuf(dupResp.outSymSeed);
        byte[] idKeyPub = idKey.outPublic.toBytes();
        actBlob.writeShort(idKeyPub.length);
        actBlob.writeByteBuf(idKeyPub);
        actBlob.writeShort(encryptedUri.length);
        actBlob.writeByteBuf(encryptedUri);
        System.arraycopy(actBlob.buffer(), 0, actBlobBuffer, 0, actBlob.curPos());
        return actBlob.curPos();
    }
}

