/*
 * Decompiled with CFR 0.152.
 */
package samples;

import java.nio.charset.Charset;
import java.util.Arrays;
import samples.CmdLine;
import samples.DrsServer;
import tss.Helpers;
import tss.Tpm;
import tss.TpmBuffer;
import tss.TpmException;
import tss.TpmHelpers;
import tss.tpm.CreatePrimaryResponse;
import tss.tpm.CreateResponse;
import tss.tpm.EncryptDecryptResponse;
import tss.tpm.ReadPublicResponse;
import tss.tpm.StartAuthSessionResponse;
import tss.tpm.TPM2B_DATA;
import tss.tpm.TPM2B_DIGEST;
import tss.tpm.TPM2B_ENCRYPTED_SECRET;
import tss.tpm.TPM2B_ID_OBJECT;
import tss.tpm.TPM2B_PRIVATE;
import tss.tpm.TPM2B_PUBLIC;
import tss.tpm.TPM2B_PUBLIC_KEY_RSA;
import tss.tpm.TPMA_OBJECT;
import tss.tpm.TPMS_KEYEDHASH_PARMS;
import tss.tpm.TPMS_NULL_ASYM_SCHEME;
import tss.tpm.TPMS_PCR_SELECTION;
import tss.tpm.TPMS_RSA_PARMS;
import tss.tpm.TPMS_SCHEME_HMAC;
import tss.tpm.TPMS_SENSITIVE_CREATE;
import tss.tpm.TPMS_SYMCIPHER_PARMS;
import tss.tpm.TPMT_PUBLIC;
import tss.tpm.TPMT_SYM_DEF;
import tss.tpm.TPMT_SYM_DEF_OBJECT;
import tss.tpm.TPM_ALG_ID;
import tss.tpm.TPM_HANDLE;
import tss.tpm.TPM_PT;
import tss.tpm.TPM_RC;
import tss.tpm.TPM_RH;
import tss.tpm.TPM_SE;

public class DrsClient {
    static final TPM_HANDLE SRK_PersHandle = TPM_HANDLE.persistent(1);
    static final TPM_HANDLE EK_PersHandle = TPM_HANDLE.persistent(65537);
    static final TPM_HANDLE ID_KEY_PersHandle = TPM_HANDLE.persistent(256);
    static final TPMT_SYM_DEF_OBJECT Aes128SymDef = new TPMT_SYM_DEF_OBJECT(TPM_ALG_ID.AES, 128, TPM_ALG_ID.CFB);
    static final TPMT_SYM_DEF_OBJECT NullSymDef = new TPMT_SYM_DEF_OBJECT(TPM_ALG_ID.AES, 128, TPM_ALG_ID.CFB);
    static final TPMT_PUBLIC EK_Template = new TPMT_PUBLIC(TPM_ALG_ID.SHA256, new TPMA_OBJECT(TPMA_OBJECT.restricted, TPMA_OBJECT.decrypt, TPMA_OBJECT.fixedTPM, TPMA_OBJECT.fixedParent, TPMA_OBJECT.adminWithPolicy, TPMA_OBJECT.sensitiveDataOrigin), Helpers.fromHex("837197674484b3f81a90cc8d46a5d724fd52d76e06520b64f2a1da1b331469aa"), new TPMS_RSA_PARMS(Aes128SymDef, new TPMS_NULL_ASYM_SCHEME(), 2048, 0), new TPM2B_PUBLIC_KEY_RSA());
    static final TPMT_PUBLIC SRK_Template = new TPMT_PUBLIC(TPM_ALG_ID.SHA256, new TPMA_OBJECT(TPMA_OBJECT.restricted, TPMA_OBJECT.decrypt, TPMA_OBJECT.fixedTPM, TPMA_OBJECT.fixedParent, TPMA_OBJECT.noDA, TPMA_OBJECT.userWithAuth, TPMA_OBJECT.sensitiveDataOrigin), new byte[0], new TPMS_RSA_PARMS(Aes128SymDef, new TPMS_NULL_ASYM_SCHEME(), 2048, 0), new TPM2B_PUBLIC_KEY_RSA());

    static void Print(String fmt, Object ... args) {
        System.out.printf(String.valueOf(fmt) + (fmt.endsWith("\n") ? "" : "\n"), args);
    }

    static void ClearPersistent(Tpm tpm, TPM_HANDLE hPers, String keyRole) {
        tpm._allowErrors().ReadPublic(hPers);
        TPM_RC rc = tpm._getLastResponseCode();
        if (rc == TPM_RC.SUCCESS) {
            DrsClient.Print("Deleting persistent %s 0x%08X", keyRole, hPers.handle);
            tpm.EvictControl(TPM_HANDLE.from(TPM_RH.OWNER), hPers, hPers);
            DrsClient.Print("Successfully deleted persistent %s 0x%08X", keyRole, hPers.handle);
        } else if (rc == TPM_RC.HANDLE) {
            DrsClient.Print("%s 0x%08X does not exist", keyRole, hPers.handle);
        } else {
            DrsClient.Print("Unexpected failure <%s> of TPM2_ReadPublic for %s 0x%08X", rc, keyRole, hPers.handle);
        }
    }

    static TPMT_PUBLIC CreatePersistentPrimary(Tpm tpm, TPM_HANDLE hPers, TPM_RH hierarchy, TPMT_PUBLIC inPub, String primaryRole) {
        ReadPublicResponse rpResp = tpm._allowErrors().ReadPublic(hPers);
        TPM_RC rc = tpm._getLastResponseCode();
        if (rc == TPM_RC.SUCCESS) {
            DrsClient.Print(">> %s already exists\r\n", primaryRole);
            return rpResp.outPublic;
        }
        if (rc != TPM_RC.HANDLE) {
            DrsClient.Print("Unexpected failure {%s} of TPM2_ReadPublic for %s 0x%08X", rc.name(), primaryRole, hPers);
            return null;
        }
        TPMS_SENSITIVE_CREATE sens = new TPMS_SENSITIVE_CREATE(new byte[0], new byte[0]);
        CreatePrimaryResponse cpResp = tpm.CreatePrimary(TPM_HANDLE.from(hierarchy), sens, inPub, new byte[0], new TPMS_PCR_SELECTION[0]);
        DrsClient.Print(">> Successfully created transient %s 0x%08X\r\n", primaryRole, cpResp.handle.handle);
        tpm.EvictControl(TPM_HANDLE.from(TPM_RH.OWNER), cpResp.handle, hPers);
        DrsClient.Print(">> Successfully persisted %s as 0x%08X\r\n", primaryRole, hPers.handle);
        tpm.FlushContext(cpResp.handle);
        return cpResp.outPublic;
    }

    static byte[] SignData(Tpm tpm, TPMT_PUBLIC idKeyPub, byte[] tokenData) {
        TPM_ALG_ID idKeyHashAlg = ((TPMS_SCHEME_HMAC)((TPMS_KEYEDHASH_PARMS)idKeyPub.parameters).scheme).hashAlg;
        int MaxInputBuffer = TpmHelpers.getTpmProperty(tpm, TPM_PT.INPUT_BUFFER);
        if (tokenData.length <= MaxInputBuffer) {
            return tpm.HMAC(ID_KEY_PersHandle, tokenData, idKeyHashAlg);
        }
        int curPos = 0;
        int bytesLeft = tokenData.length;
        TPM_HANDLE hSeq = tpm.HMAC_Start(ID_KEY_PersHandle, new byte[0], idKeyHashAlg);
        do {
            tpm.SequenceUpdate(hSeq, Arrays.copyOfRange(tokenData, curPos, curPos + MaxInputBuffer));
            curPos += MaxInputBuffer;
        } while ((bytesLeft -= MaxInputBuffer) > MaxInputBuffer);
        return tpm.SequenceComplete((TPM_HANDLE)hSeq, (byte[])Arrays.copyOfRange((byte[])tokenData, (int)curPos, (int)(curPos + bytesLeft)), (TPM_HANDLE)TPM_HANDLE.from((TPM_RH)TPM_RH.NULL)).result;
    }

    public static void runProvisioningSequence(Tpm tpm) {
        try {
            byte[] srkBlobToSend;
            if (CmdLine.isOptionPresent("clear", "c")) {
                System.out.println("Clearing keys ...");
                DrsClient.ClearPersistent(tpm, EK_PersHandle, "EK");
                DrsClient.ClearPersistent(tpm, SRK_PersHandle, "SRK");
                DrsClient.ClearPersistent(tpm, ID_KEY_PersHandle, "ID");
                return;
            }
            TPMT_PUBLIC ekPub = null;
            TPMT_PUBLIC srkPub = null;
            ekPub = DrsClient.CreatePersistentPrimary(tpm, EK_PersHandle, TPM_RH.ENDORSEMENT, EK_Template, "EK");
            srkPub = DrsClient.CreatePersistentPrimary(tpm, SRK_PersHandle, TPM_RH.OWNER, SRK_Template, "SRK");
            int blobBufCapacity = 4096;
            byte[] actBlobBuffer = new byte[blobBufCapacity];
            int actBlobSize = 0;
            byte[] ekBlobToSend = new TPM2B_PUBLIC(ekPub).toBytes();
            actBlobSize = DrsServer.GetActivationBlob2(tpm, ekBlobToSend, ekBlobToSend.length, srkBlobToSend = new TPM2B_PUBLIC(srkPub).toBytes(), srkBlobToSend.length, actBlobBuffer, blobBufCapacity);
            if (actBlobSize <= 0) {
                throw new Exception("Unexpected DRS failure");
            }
            TpmBuffer actBlob = new TpmBuffer(Arrays.copyOfRange(actBlobBuffer, 0, actBlobSize));
            TPM2B_ID_OBJECT credBlob = TPM2B_ID_OBJECT.fromTpm(actBlob);
            DrsClient.Print("credBlob end: %d", actBlob.curPos());
            TPM2B_ENCRYPTED_SECRET encSecret = TPM2B_ENCRYPTED_SECRET.fromTpm(actBlob);
            DrsClient.Print("encSecret end: %d", actBlob.curPos());
            TPM2B_PRIVATE idKeyDupBlob = TPM2B_PRIVATE.fromTpm(actBlob);
            DrsClient.Print("idKeyDupBlob end: %d", actBlob.curPos());
            TPM2B_ENCRYPTED_SECRET encWrapKey = TPM2B_ENCRYPTED_SECRET.fromTpm(actBlob);
            DrsClient.Print("encWrapKey end: %d", actBlob.curPos());
            TPM2B_PUBLIC idKeyPub = TPM2B_PUBLIC.fromTpm(actBlob);
            DrsClient.Print("idKeyPub end: %d", actBlob.curPos());
            TPM2B_DATA encUriData = TPM2B_DATA.fromTpm(actBlob);
            DrsClient.Print("encUriData end: %d", actBlob.curPos());
            StartAuthSessionResponse sasResp = tpm.StartAuthSession(TPM_HANDLE.NULL, TPM_HANDLE.NULL, Helpers.RandomBytes(20), new byte[0], TPM_SE.POLICY, new TPMT_SYM_DEF(TPM_ALG_ID.NULL, 0, TPM_ALG_ID.NULL), TPM_ALG_ID.SHA256);
            tpm.PolicySecret(TPM_HANDLE.from(TPM_RH.ENDORSEMENT), sasResp.handle, new byte[0], new byte[0], new byte[0], 0);
            byte[] innerWrapKey = tpm._withSessions(TPM_HANDLE.pwSession(new byte[0]), sasResp.handle).ActivateCredential(SRK_PersHandle, EK_PersHandle, credBlob.credential, encSecret.secret);
            TPMT_SYM_DEF_OBJECT symDef = new TPMT_SYM_DEF_OBJECT(TPM_ALG_ID.AES, innerWrapKey.length * 8, TPM_ALG_ID.CFB);
            TPM2B_PRIVATE idKeyPriv = tpm.Import(SRK_PersHandle, innerWrapKey, idKeyPub.publicArea, idKeyDupBlob, encWrapKey.secret, symDef);
            TPM_HANDLE hIdkey = tpm.Load(SRK_PersHandle, idKeyPriv, idKeyPub.publicArea);
            DrsClient.ClearPersistent(tpm, ID_KEY_PersHandle, "ID Key");
            tpm.EvictControl(TPM_HANDLE.from(TPM_RH.OWNER), hIdkey, ID_KEY_PersHandle);
            DrsClient.Print("Successfully created persistent %s 0x%08X\r\n", "ID Key", DrsClient.ID_KEY_PersHandle.handle);
            tpm.FlushContext(hIdkey);
            int maxUriDataSize = TpmHelpers.getTpmProperty(tpm, TPM_PT.INPUT_BUFFER);
            if (encUriData.buffer.length > maxUriDataSize) {
                throw new Exception("Too long encrypted URI data string. Max supported length is " + Integer.toString(maxUriDataSize));
            }
            TPMT_PUBLIC symTemplate = new TPMT_PUBLIC(TPM_ALG_ID.SHA256, new TPMA_OBJECT(TPMA_OBJECT.decrypt, TPMA_OBJECT.fixedTPM, TPMA_OBJECT.fixedParent, TPMA_OBJECT.userWithAuth), new byte[0], new TPMS_SYMCIPHER_PARMS(symDef), new TPM2B_DIGEST());
            TPMS_SENSITIVE_CREATE sensCreate = new TPMS_SENSITIVE_CREATE(new byte[0], innerWrapKey);
            CreateResponse crResp = tpm.Create(SRK_PersHandle, sensCreate, symTemplate, new byte[0], new TPMS_PCR_SELECTION[0]);
            TPM_HANDLE hSymKey = tpm.Load(SRK_PersHandle, crResp.outPrivate, crResp.outPublic);
            byte[] iv = new byte[innerWrapKey.length];
            EncryptDecryptResponse edResp = tpm.EncryptDecrypt(hSymKey, (byte)1, TPM_ALG_ID.CFB, iv, encUriData.buffer);
            DrsClient.Print("Decrypted URI data size: %d", edResp.outData.length);
            DrsClient.Print("Decrypted URI [for native]: %s", new String(edResp.outData, Charset.forName("UTF-8")));
            DrsClient.Print("Decrypted URI [for java]: %s", new String(edResp.outData));
            tpm.FlushContext(hSymKey);
            byte[] deviceIdData = Helpers.RandomBytes(2550);
            byte[] signature = DrsClient.SignData(tpm, idKeyPub.publicArea, deviceIdData);
            int rc = DrsServer.VerifyIdSignature(tpm, deviceIdData, signature);
            if (rc != TPM_RC.SUCCESS.toInt()) {
                throw new Exception("Failed to verify a signature created by the new Device ID key");
            }
            DrsClient.Print("Successfully verified a signature created by the new Device ID key", new Object[0]);
        }
        catch (TpmException te) {
            String rcName = te.ResponseCode == null ? "<NONE>" : te.ResponseCode.name();
            String msg = te.getMessage();
            DrsClient.Print("A TPM operations FAILED: error {%s}; message \"%s\"", rcName, msg);
        }
        catch (Exception e) {
            DrsClient.Print("An operation FAILED: Error message: \"%s\"", e.getMessage());
        }
        DrsClient.Print("RunProvisioningSequence finished!", new Object[0]);
    }
}

