var $mainTree = $("#mainTree");
var $contextmenu = $("#mainTreeContextmenu");
var $mainTreePanel = $("#mainTreePanel");
var $mainGrid = $("#mainGrid");
var ddvGrid;
var treeNode;

$(function () {
    initMainTree();
    $("#addFlow").click(add);
    $("#editFlow").click(edit);
    $("#queryBtn").click(query);
    $("#delFlow").click(del);
    $mainGrid.datagrid({
        view: detailview,
        detailFormatter: function (index, row) {
            return '<div style="padding: 5px 0px"><table class="easyui-datagrid ddv"></table></div>';
        },
        onExpandRow: function (index, row) {
            ddvGrid = $(this).datagrid('getRowDetail', index).find('table.ddv');
            ddvGrid.datagrid({
                url: 'businessProcess/queryWorkFlowVersion?processDefName=' + row.designName,
                fitColumns: false,
                fit: false,
                border: true,
                pagination: false,
                height: 'auto',
                columns: [[
                    {field: 'versionSign', title: '版本号', width: 50},
                    {field: 'createTime', title: '创建时间', width: 150},
                    {field: 'updateTime', title: '最近修改时间', width: 150},
                    {field: 'creator', title: '创建人', width: 50},
                    {field: 'currentState', title: '状态', width: 50, formatter: fmtStatus},
                    {field: 'description', title: '版本说明', width: 200},
                    {field: 'opt', title: '操作', width: 300, formatter: fmtOptSub}
                ]],
                onResize: function () {
                    $mainGrid.datagrid('fixDetailRowHeight', index);
                },
                onLoadSuccess: function () {
                    setTimeout(function () {
                        $mainGrid.datagrid('fixDetailRowHeight', index);
                    }, 0);
                }
            });
            $mainGrid.datagrid('fixDetailRowHeight', index);
        }
    });
    $mainTreePanel.bind('contextmenu', function (e) {
        e.preventDefault();
        $contextmenu.empty();
        $contextmenu.menu('appendItem', {
            text: '添加根节点',
            onclick: addRootNode
        });
        $contextmenu.menu('appendItem', {
            text: '刷新',
            onclick: reloadTree
        });
        $contextmenu.menu('show', {
            left: e.pageX,
            top: e.pageY
        });
    });
})

function initMainTree() {
    $mainTree.tree({
        fit: true,
        dnd: true,
        url: 'businessProcess/treeStfBusinessTypeWithRoot',
        onSelect: function (node) {
            treeNode = node;
            loadMainGrid(node);
        },
        onLoadSuccess: function (node, data) {
            $mainTree.tree("collapseAll");
            var node = $mainTree.tree('find', data[0].resId);
            $mainTree.tree('select', node.target);
        },
        onContextMenu: function (e, node) {
            e.preventDefault();
            $(this).tree('select', node.target);
            $contextmenu.empty();
            $contextmenu.menu('appendItem', {
                text: '添加',
                onclick: addTreeNode
            });
            $contextmenu.menu('appendItem', {
                text: '修改',
                onclick: editTreeNode
            });
            $contextmenu.menu('appendItem', {
                text: '删除',
                onclick: deleteTreeNode
            });
            $contextmenu.menu('show', {
                left: e.pageX,
                top: e.pageY
            });
        }
    });
}

function loadMainGrid(node) {
    $mainGrid.datagrid('options').url = "businessProcess/findAll";
    $mainGrid.datagrid('load', {orgId: node.id});
}

function add() {
    UIKit.modalDialog({
        url: "businessProcess/StfBusinessProcessForm",
        title: "新增流程信息",
        width: "40%",
        height: "400px",
        params: {data: {businessTypeId: treeNode.id}},
        onClose: function (result) {
            if (result) {
                if (result) {
                    $mainGrid.datagrid('reload');
                }
            }
        }
    });
}

function edit() {
    UIKit.notEmptyAndThen($mainGrid.datagrid("getSelected"), function (row) {
        UIKit.modalDialog({
            url: "businessProcess/StfBusinessProcessForm",
            title: "修改流程信息",
            width: "40%",
            height: "400px",
            params: {
                data: row
            },
            onClose: function (result) {
                if (result) {
                    if (result) {
                        $mainGrid.datagrid('reload');
                    }
                }
            }
        })
    }, "请选择流程");
}

function del() {
    UIKit.notEmptyAndThen($mainGrid.datagrid("getSelected"), function (row) {
        UIKit.confirm("确定删除该流程吗？", {}, function () {
            UIKit.ajaxLoading("businessProcess/delStfBusinessProcess", {id: row.resId}, function (result) {
                UIKit.tipResult(result);
                $mainGrid.datagrid("deleteRow", $mainGrid.datagrid('getRowIndex', row));
            });
        })
    }, "选择要删除的模版");
}

function query() {
    $mainGrid.datagrid('load', {
        orgId: treeNode.id,
        search: $("#search").val(),
        type: $("#flow_typ").val()
    });
}

function optFmt(value, row, index) {
    return "<div class=\"btn-group\" style='margin-right: 2px'>\n" +
        "  <a  class=\"btn btn-xs\" onclick=\"addProcessDefine('" + index + "')\">新建版本</a>\n" +
        "</div>";
}

function fmtOptSub(value, row, index) {
    var html = "";
    html += "<div class=\"btn-group\" style='margin-right: 2px'>\n" +
        "  <a  class=\"btn btn-xs\" onclick=\"editProcessDefine('" + row.processDefId + "','" + row.processCHName + "','" + row.processDefName + "','" + row.versionSign + "')\">版本修改</a>\n" +
        "</div>";
    html += "<div class=\"btn-group\" style='margin-right: 2px'>\n" +
        "  <a  class=\"btn btn-xs\" onclick=\"delProcessDefine('" + row.processDefId + "')\">版本删除</a>\n" +
        "</div>";
    html += "<div class=\"btn-group\" style='margin-right: 2px'>\n" +
        "  <a  class=\"btn btn-xs\" onclick=\"pubProcessDefine('" + row.processDefId + "')\">版本发布</a>\n" +
        "</div>";
    html += "<div class=\"btn-group\" style='margin-right: 2px'>\n" +
        "  <a  class=\"btn btn-xs\" onclick=\"cancelProcessDefine('" + row.processDefId + "')\">取消发布</a>\n" +
        "</div>";
    return html;
}

function fmtStatus(value, row, index) {
    if (row.currentState === 0) {
        return '未发布';
    } else if (row.currentState === 3) {
        return '已发布';
    }
    return '修改中';
}

function addProcessDefine(rowindex) {
    $mainGrid.datagrid("selectRow", rowindex);
    var _maxversion = '';
    UIKit.notEmptyAndThen($mainGrid.datagrid("getSelected"), function (val) {
        UIKit.ajaxLoading("businessProcess/queryWorkFlowVersion?processDefName=" + val.designName, function (res) {
            for (var i = 0; i < res.data.length; i++) {
                if (res.data[i].versionSign > _maxversion)
                    _maxversion = res.data[i].versionSign
            }
            var row = {
                processDefId: '0',
                processCHName: val.flowName,
                processDefName: val.designName,
                version: _maxversion
            };
            var flashurl = ctxPath + "/wf/jsflow?status=new&busiId=" + treeNode.id + "&processDefId=" + row.processDefId + "&processCHName=" + encodeURIComponent(row.processCHName) + "&processDefName=" + row.processDefName + "&version=" + row.version;
            openDefineDetail(flashurl);
        });
    }, "选择要新增版本的流程");
}

function openDefineDetail(flashUrl) {
    window.open(flashUrl);
}

function editProcessDefine(processDefId, processCHName, processDefName, versionSign) {
    var flashUrl = ctxPath + "/wf/jsflow?status=update&busiId=" + treeNode.id + "&processDefId=" + processDefId + "&processCHName=" + encodeURIComponent(processCHName) + "&processDefName=" + processDefName + "&version=" + versionSign;
    openDefineDetail(flashUrl);
}

function delProcessDefine(processDefId) {
    UIKit.notEmptyAndThen($mainGrid.datagrid("getSelected"), function (row) {
        UIKit.confirm("您是否要删除当前选中的流程实例？", {}, function () {
            UIKit.ajaxLoading("pd/delProcessDefine", {id: processDefId}, function (result) {
                UIKit.tipResult(result);
                ddvGrid.datagrid("reload");
            });
        })
    });
}

function pubProcessDefine(processDefId) {
    var flag = false;
    UIKit.notEmptyAndThen($mainGrid.datagrid("getSelected"), function (row) {
        UIKit.ajaxLoading("businessProcess/publishStatus?processDefName=" + row.designName, function (result) {
            flag = result.data;
            if (flag) {
                UIKit.confirm("您是否要发布当前选中的流程实例并将取消其他已发布实例？", {}, function () {
                    UIKit.ajaxLoading("businessProcess/pubProcessDefine", {
                        id: processDefId,
                        processDefName: row.designName
                    }, function (result) {
                        UIKit.tipResult(result);
                        ddvGrid.datagrid("reload");
                    });
                })
            } else {
                UIKit.confirm("您是否要发布当前选中的流程实例？", {}, function () {
                    UIKit.ajaxLoading("businessProcess/pubProcessDefine", {
                        id: processDefId,
                        processDefName: row.designName
                    }, function (result) {
                        UIKit.tipResult(result);
                        ddvGrid.datagrid("reload");
                    });
                })
            }
        });
    });
}

function cancelProcessDefine(processDefId) {
    UIKit.notEmptyAndThen($mainGrid.datagrid("getSelected"), function (row) {
        UIKit.confirm("您是否要取消发布？", {}, function () {
            UIKit.ajaxLoading("pd/cancelProcessDefine", {id: processDefId}, function (result) {
                UIKit.tipResult(result);
                ddvGrid.datagrid("reload");
            });
        })
    });
}

function addRootNode() {
    UIKit.notEmptyAndThen($mainTree.tree('getSelected'), function (node) {
        UIKit.modalDialog({
            url: "businessType/index",
            title: "新增流程目录",
            width: "40%",
            height: "400px",
            params: {},
            onClose: function (result) {
                $mainTree.tree('updateWithNodeDataAndSelect', result);
            }
        })
    })
}

function editTreeNode() {
    UIKit.notEmptyAndThen($mainTree.tree('getSelected'), function (node) {
        UIKit.modalDialog({
            url: "businessType/index",
            title: "添加流程目录",
            width: "40%",
            height: "400px",
            params: {
                data: node
            },
            onClose: function (result) {
                $mainTree.tree('updateWithNodeDataAndSelect', result);
            }
        })
    }, "选择要修改的节点")
}

function addTreeNode() {
    UIKit.notEmptyAndThen($mainTree.tree('getSelected'), function (node) {
        UIKit.modalDialog({
            url: "businessType/index",
            title: "新增流程目录",
            width: "40%",
            height: "400px",
            params: {
                data: {parentId: node.resId}
            },
            onClose: function (result) {
                $mainTree.tree('updateWithNodeDataAndSelect', result);
            }
        })
    }, "选择要添加的节点")
}

function reloadTree() {
    $mainTree.tree("reload");
}

function deleteTreeNode() {
    UIKit.notEmptyAndThen($mainTree.tree('getSelected'), function (node) {
        UIKit.confirm("确定删除该目录?", {}, function () {
            UIKit.ajaxLoading("businessType/delStfBusinessTypeAndChild", {id: node.id}, function (result) {
                UIKit.tipResult(result);
                if (result.success) {
                    $mainTree.tree("remove", node.target);
                }

            });
        })
    }, "选择要删除的菜单");
}

