/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.workflow.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.kdgcsoft.uframe.common.util.TreeUtil;
import com.kdgcsoft.uframe.mybatis.interfaces.UFrameWrapper;
import com.kdgcsoft.uframe.mybatis.wrapper.JoinLambdaWrapper;
import com.kdgcsoft.uframe.web.common.model.PageRequest;
import com.kdgcsoft.workflow.entity.StfBusinessProcess;
import com.kdgcsoft.workflow.entity.StfBusinessType;
import com.kdgcsoft.workflow.entity.WfProcessDefine;
import com.kdgcsoft.workflow.mapper.BusinessProcessMapper;
import com.kdgcsoft.workflow.mapper.BusinessTypeMapper;
import com.kdgcsoft.workflow.mapper.ProcessDefineMapper;
import com.kdgcsoft.workflow.service.ProcessDefineService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusinessProcessService
extends ServiceImpl<BusinessProcessMapper, StfBusinessProcess> {
    @Resource
    private BusinessTypeMapper businessTypeMapper;
    @Resource
    private ProcessDefineMapper processDefineMapper;
    @Autowired
    private ProcessDefineService processDefineService;
    public static final int PUB_STATE = 3;
    public static final int CANCEL_STATE = 4;

    public List<StfBusinessType> treeStfBusinessTypeWithRoot() {
        List list = this.businessTypeMapper.selectList((Wrapper)new QueryWrapper());
        return TreeUtil.buildTree((List)list);
    }

    public PageRequest pageStfBusinessProcess(PageRequest pageRequest, String businessTypeId, String search, String type) {
        ArrayList<Long> businessTypeIds = null;
        if (StringUtils.isNotEmpty((CharSequence)businessTypeId)) {
            businessTypeIds = new ArrayList<Long>();
            long typeId = Long.parseLong(businessTypeId);
            businessTypeIds.add(typeId);
            List<StfBusinessType> sons = this.getAllSons(typeId);
            for (StfBusinessType s : sons) {
                businessTypeIds.add(s.getResId());
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)search)) {
            search = search.toLowerCase();
        }
        String finalSearch = search;
        ((BusinessProcessMapper)this.baseMapper).selectJoinPage((IPage)pageRequest, StfBusinessProcess.class, (UFrameWrapper)((JoinLambdaWrapper)((JoinLambdaWrapper)((JoinLambdaWrapper)((JoinLambdaWrapper)((JoinLambdaWrapper)((JoinLambdaWrapper)new JoinLambdaWrapper().selectAll(StfBusinessProcess.class).selectAs(StfBusinessType::getName, StfBusinessProcess::getBusinessTypeName)).selectAs(StfBusinessProcess::getType, StfBusinessProcess::getTypeName)).leftJoin(StfBusinessType.class, StfBusinessType::getResId, StfBusinessProcess::getBusinessTypeId)).in(StfBusinessProcess::getBusinessTypeId, businessTypeIds)).eq(StrUtil.isNotEmpty((CharSequence)type), StfBusinessProcess::getType, (Object)type)).and(StrUtil.isNotEmpty((CharSequence)search), q -> {
            JoinLambdaWrapper cfr_ignored_0 = (JoinLambdaWrapper)((JoinLambdaWrapper)((JoinLambdaWrapper)((JoinLambdaWrapper)((JoinLambdaWrapper)((JoinLambdaWrapper)((JoinLambdaWrapper)((JoinLambdaWrapper)((JoinLambdaWrapper)((JoinLambdaWrapper)((JoinLambdaWrapper)q.like(StfBusinessProcess::getDesignName, (Object)finalSearch)).or()).like(StfBusinessProcess::getMemo, (Object)finalSearch)).or()).like(StfBusinessProcess::getResCreator, (Object)finalSearch)).or()).like(StfBusinessProcess::getResEditor, (Object)finalSearch)).or()).like(StfBusinessProcess::getFlowName, (Object)finalSearch)).or()).like(StfBusinessProcess::getType, (Object)finalSearch);
        })).orderByDesc(StfBusinessType::getResId, new SFunction[0]));
        return pageRequest;
    }

    private List<StfBusinessType> getAllSons(List<StfBusinessType> all, List<StfBusinessType> fathers, Map<Long, List<StfBusinessType>> stfBusinessTypeMap) {
        if (CollUtil.isNotEmpty(fathers)) {
            List<StfBusinessType> sons = fathers.stream().map(t -> stfBusinessTypeMap.getOrDefault(t.getResId(), Collections.emptyList())).flatMap(Collection::stream).collect(Collectors.toList());
            all.addAll(sons);
            return this.getAllSons(all, sons, stfBusinessTypeMap);
        }
        return all;
    }

    public List<StfBusinessType> getAllSons(Long pid) {
        List all = this.businessTypeMapper.selectList(null);
        Map<Long, List<StfBusinessType>> stfBusinessTypeMap = all.stream().collect(Collectors.groupingBy(StfBusinessType::getParentId));
        List<StfBusinessType> firstLevelChildren = Optional.ofNullable(stfBusinessTypeMap.get(pid)).orElse(Collections.emptyList());
        ArrayList<StfBusinessType> sons = new ArrayList<StfBusinessType>(firstLevelChildren);
        return this.getAllSons(sons, firstLevelChildren, stfBusinessTypeMap);
    }

    public StfBusinessProcess saveStfBusinessProcess(StfBusinessProcess entity) {
        if (entity.getResId() == null) {
            ((BusinessProcessMapper)this.baseMapper).insert(entity);
            StfBusinessProcess newEntity = (StfBusinessProcess)((BusinessProcessMapper)this.baseMapper).selectById(entity.getResId());
            newEntity.setDesignName(newEntity.getType() + "." + String.valueOf(newEntity.getResId()));
            ((BusinessProcessMapper)this.baseMapper).updateById(newEntity);
        } else {
            ((BusinessProcessMapper)this.baseMapper).updateById(entity);
        }
        return entity;
    }

    public void delStfBusinessProcess(Long id) {
        ((BusinessProcessMapper)this.baseMapper).deleteById(id);
    }

    public List<WfProcessDefine> queryWorkFlowVersion(String processDefName) {
        return this.processDefineMapper.selectList((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(WfProcessDefine::getProcessDefName, (Object)processDefName)).orderByDesc(WfProcessDefine::getVersionSign, (Object[])new SFunction[0]));
    }

    public void pubProcessDefine(Long id, String processDefName) {
        List list = this.processDefineMapper.selectList((Wrapper)new QueryWrapper().lambda().eq(WfProcessDefine::getProcessDefName, (Object)processDefName));
        list.stream().forEach(x -> {
            if (x.getCurrentState() == 3) {
                x.setCurrentState(4);
            }
            if (x.getProcessDefId() == id) {
                x.setCurrentState(3);
            }
        });
        this.processDefineService.saveOrUpdateBatch(list);
    }

    public Boolean publishStatus(String processDefName) {
        List<Object> defines = new ArrayList();
        List list = this.processDefineMapper.selectList((Wrapper)new QueryWrapper().lambda().eq(WfProcessDefine::getProcessDefName, (Object)processDefName));
        if (CollUtil.isNotEmpty((Collection)list)) {
            defines = list.stream().filter(x -> x.getCurrentState() == 3).collect(Collectors.toList());
        }
        if (CollUtil.isEmpty(defines)) {
            return false;
        }
        return true;
    }
}

