/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.workflow.controller;

import com.kdgcsoft.uframe.common.model.JsonResult;
import com.kdgcsoft.uframe.web.common.controller.BaseController;
import com.kdgcsoft.uframe.web.common.model.PageRequest;
import com.kdgcsoft.workflow.entity.StfBusinessProcess;
import com.kdgcsoft.workflow.entity.StfBusinessType;
import com.kdgcsoft.workflow.entity.WfProcessDefine;
import com.kdgcsoft.workflow.service.BusinessProcessService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/businessProcess"})
public class BusinessProcessController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(BusinessProcessController.class);
    @Autowired
    private BusinessProcessService stfBusinessProcessService;

    @RequestMapping(value={"/index"})
    public ModelAndView index(ModelAndView model) {
        model.setViewName("workflow/BusinessProcess.html");
        return model;
    }

    @RequestMapping(value={"/StfBusinessProcessForm"}, method={RequestMethod.GET})
    public ModelAndView idxForm() {
        return this.view("workflow/BusinessProcess_form.html");
    }

    @RequestMapping(value={"/treeStfBusinessTypeWithRoot"})
    @ResponseBody
    public JsonResult<List<StfBusinessType>> treeStfBusinessTypeWithRoot() {
        return JsonResult.ok().data(this.stfBusinessProcessService.treeStfBusinessTypeWithRoot());
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6570\u636e,\u5e26\u5206\u9875\u548c\u6a21\u7cca\u641c\u7d22")
    @RequestMapping(value={"/findAll"})
    @ResponseBody
    public JsonResult pageStfBusinessProcess(PageRequest pageRequest, @ApiParam(value="orgId", defaultValue="") String orgId, @ApiParam(value="search", defaultValue="") String search, @ApiParam(value="type", defaultValue="") String type) {
        return JsonResult.ok().data((Object)this.stfBusinessProcessService.pageStfBusinessProcess(pageRequest, orgId, search, type));
    }

    @ApiOperation(value="\u67e5\u8be2\u5b50\u8868\u6570\u636e")
    @RequestMapping(value={"/queryWorkFlowVersion"})
    @ResponseBody
    public JsonResult queryWorkFlowVersion(@ApiParam(value="processDefName") String processDefName) {
        List<WfProcessDefine> list = this.stfBusinessProcessService.queryWorkFlowVersion(processDefName);
        return JsonResult.ok().data(list);
    }

    @ApiOperation(value="\u6d41\u7a0b\u4fe1\u606f\u4fdd\u5b58")
    @RequestMapping(value={"/saveStfBusinessProcess"})
    @ResponseBody
    public JsonResult saveStfBusinessProcess(StfBusinessProcess entity) {
        return JsonResult.ok().data((Object)this.stfBusinessProcessService.saveStfBusinessProcess(entity));
    }

    @ApiOperation(value="\u6d41\u7a0b\u4fe1\u606f\u5220\u9664")
    @RequestMapping(value={"/delStfBusinessProcess"})
    @ResponseBody
    public JsonResult delStfBusinessProcess(Long id) {
        this.stfBusinessProcessService.delStfBusinessProcess(id);
        return JsonResult.ok();
    }

    @ApiOperation(value="\u6d41\u7a0b\u53d1\u5e03")
    @RequestMapping(value={"/pubProcessDefine"})
    @ResponseBody
    public JsonResult pubProcessDefine(Long id, String processDefName) {
        this.stfBusinessProcessService.pubProcessDefine(id, processDefName);
        return JsonResult.ok();
    }

    @ApiOperation(value="\u67e5\u8be2\u53d1\u5e03\u72b6\u6001")
    @RequestMapping(value={"/publishStatus"})
    @ResponseBody
    public JsonResult publishStatus(String processDefName) {
        Boolean flag = this.stfBusinessProcessService.publishStatus(processDefName);
        return JsonResult.ok().data((Object)flag);
    }
}

