CREATE TABLE "public"."base_job" (
                                     "job_id" varchar(32) COLLATE "pg_catalog"."default" NOT NULL,
                                     "job_name" varchar(128) COLLATE "pg_catalog"."default",
                                     "job_class" varchar(256) COLLATE "pg_catalog"."default",
                                     "job_param" varchar(256) COLLATE "pg_catalog"."default",
                                     "job_cron" varchar(256) COLLATE "pg_catalog"."default",
                                     "job_status" varchar(32) COLLATE "pg_catalog"."default",
                                     "enabled" varchar(32) COLLATE "pg_catalog"."default",
                                     "ord_no" int8,
                                     "rmk" varchar(256) COLLATE "pg_catalog"."default",
                                     "deleted" int2,
                                     "create_by" int8,
                                     "create_time" timestamp(6),
                                     "modify_by" int8,
                                     "modify_time" timestamp(6),
                                     CONSTRAINT "base_job_pk" PRIMARY KEY ("job_id")
)
;

ALTER TABLE "public"."base_job"
    OWNER TO "system";

COMMENT ON COLUMN "public"."base_job"."job_id" IS '任务id';

COMMENT ON COLUMN "public"."base_job"."job_name" IS '任务名称';

COMMENT ON COLUMN "public"."base_job"."job_class" IS '任务java类';

COMMENT ON COLUMN "public"."base_job"."job_param" IS '任务参数';

COMMENT ON COLUMN "public"."base_job"."job_cron" IS 'cron表达式';

COMMENT ON COLUMN "public"."base_job"."job_status" IS '任务状态';

COMMENT ON COLUMN "public"."base_job"."enabled" IS '是否启用';

COMMENT ON COLUMN "public"."base_job"."ord_no" IS '排序';

COMMENT ON COLUMN "public"."base_job"."rmk" IS '备注';

COMMENT ON COLUMN "public"."base_job"."deleted" IS '是否删除';

COMMENT ON COLUMN "public"."base_job"."create_by" IS '创建人';

COMMENT ON COLUMN "public"."base_job"."create_time" IS '创建时间';

COMMENT ON COLUMN "public"."base_job"."modify_by" IS '修改人';

COMMENT ON COLUMN "public"."base_job"."modify_time" IS '修改时间';

COMMENT ON TABLE "public"."base_job" IS '定时任务';


CREATE TABLE "public"."base_job_log" (
                                         "job_log_id" varchar(32) COLLATE "pg_catalog"."default" NOT NULL,
                                         "job_id" varchar(32) COLLATE "pg_catalog"."default" NOT NULL,
                                         "job_name" varchar(128) COLLATE "pg_catalog"."default",
                                         "job_class" varchar(256) COLLATE "pg_catalog"."default",
                                         "job_param" varchar(256) COLLATE "pg_catalog"."default",
                                         "start_time" timestamp(6),
                                         "end_time" timestamp(6),
                                         "time_cost" int8,
                                         "exec_info" text COLLATE "pg_catalog"."default",
                                         "job_status" varchar(32) COLLATE "pg_catalog"."default",
                                         "deleted" int2,
                                         "create_by" int8,
                                         "create_time" timestamp(6),
                                         "modify_by" int8,
                                         "modify_time" timestamp(6),
                                         CONSTRAINT "base_job_log_pk" PRIMARY KEY ("job_log_id")
)
;

ALTER TABLE "public"."base_job_log"
    OWNER TO "system";

COMMENT ON COLUMN "public"."base_job_log"."job_log_id" IS '任务日志id';

COMMENT ON COLUMN "public"."base_job_log"."job_id" IS '任务id';

COMMENT ON COLUMN "public"."base_job_log"."job_name" IS '任务名称';

COMMENT ON COLUMN "public"."base_job_log"."job_class" IS '任务java类';

COMMENT ON COLUMN "public"."base_job_log"."job_param" IS '任务参数';

COMMENT ON COLUMN "public"."base_job_log"."start_time" IS '开始时间';

COMMENT ON COLUMN "public"."base_job_log"."end_time" IS '结束时间';

COMMENT ON COLUMN "public"."base_job_log"."time_cost" IS '耗时(ms)';

COMMENT ON COLUMN "public"."base_job_log"."exec_info" IS '执行信息';

COMMENT ON COLUMN "public"."base_job_log"."job_status" IS '任务状态';

COMMENT ON COLUMN "public"."base_job_log"."deleted" IS '是否删除';

COMMENT ON COLUMN "public"."base_job_log"."create_by" IS '创建人';

COMMENT ON COLUMN "public"."base_job_log"."create_time" IS '创建时间';

COMMENT ON COLUMN "public"."base_job_log"."modify_by" IS '修改人';

COMMENT ON COLUMN "public"."base_job_log"."modify_time" IS '修改时间';

COMMENT ON TABLE "public"."base_job_log" IS '定时任务日志';