/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.dm;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.database.dm.DmConnection;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.util.StringUtils;

public class DmDatabase
extends Database<DmConnection> {
    private static final String DM_NET_TNS_ADMIN = "dm.net.tns_admin";

    public static void enableTnsnamesOraSupport() {
        String tnsAdminEnvVar = System.getenv("TNS_ADMIN");
        String tnsAdminSysProp = System.getProperty(DM_NET_TNS_ADMIN);
        if (StringUtils.hasLength((String)tnsAdminEnvVar) && tnsAdminSysProp == null) {
            System.setProperty(DM_NET_TNS_ADMIN, tnsAdminEnvVar);
        }
    }

    public DmDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        super(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    protected DmConnection doGetConnection(Connection connection) {
        return new DmConnection(this, connection);
    }

    public boolean supportsChangingCurrentSchema() {
        return true;
    }

    public String doQuote(String identifier) {
        return "\"" + identifier + "\"";
    }

    public void ensureSupported() {
        this.ensureDatabaseIsRecentEnough("7");
        this.recommendFlywayUpgradeIfNecessary("8.1");
    }

    public String getRawCreateScript(Table table, boolean baseline) {
        String tablespace = this.configuration.getTablespace() == null ? "" : " TABLESPACE \"" + this.configuration.getTablespace() + "\"";
        return "CREATE TABLE " + table + " (\n    \"installed_rank\" INT NOT NULL,\n    \"version\" VARCHAR2(50),\n    \"description\" VARCHAR2(200) NOT NULL,\n    \"type\" VARCHAR2(20) NOT NULL,\n    \"script\" VARCHAR2(1000) NOT NULL,\n    \"checksum\" INT,\n    \"installed_by\" VARCHAR2(100) NOT NULL,\n    \"installed_on\" TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,\n    \"execution_time\" INT NOT NULL,\n    \"success\" NUMBER(1) NOT NULL,\n    CONSTRAINT \"" + table.getName() + "_pk\" PRIMARY KEY (\"installed_rank\")\n)" + tablespace + ";\n" + (String)(baseline ? this.getBaselineStatement(table) + ";\n" : "") + "CREATE INDEX \"" + table.getSchema().getName() + "\".\"" + table.getName() + "_s_idx\" ON " + table + " (\"success\");\n";
    }

    public boolean supportsEmptyMigrationDescription() {
        return false;
    }

    protected String doGetCatalog() throws SQLException {
        return super.doGetCatalog();
    }

    protected String doGetCurrentUser() throws SQLException {
        return ((DmConnection)this.getMainConnection()).getJdbcTemplate().queryForString("SELECT USER FROM DUAL", new String[0]);
    }

    public boolean supportsDdlTransactions() {
        return false;
    }

    public String getBooleanTrue() {
        return "1";
    }

    public String getBooleanFalse() {
        return "0";
    }

    public boolean catalogIsSchema() {
        return false;
    }

    boolean queryReturnsRows(String query, String ... params) throws SQLException {
        return ((DmConnection)this.getMainConnection()).getJdbcTemplate().queryForBoolean("SELECT CASE WHEN EXISTS(" + query + ") THEN 1 ELSE 0 END FROM DUAL", params);
    }

    boolean isPrivOrRoleGranted(String name) throws SQLException {
        return this.queryReturnsRows("SELECT 1 FROM SESSION_PRIVS WHERE PRIVILEGE = ? UNION ALL SELECT 1 FROM SESSION_ROLES WHERE ROLE = ?", name, name);
    }

    private boolean isDataDictViewAccessible(String owner, String name) throws SQLException {
        return this.queryReturnsRows("SELECT * FROM ALL_TAB_PRIVS WHERE OWNER = ? AND TABLE_NAME = ? AND PRIVILEGE = 'SELECT'", owner, name);
    }

    boolean isDataDictViewAccessible(String name) throws SQLException {
        return this.isDataDictViewAccessible("SYS", name);
    }

    String dbaOrAll(String baseName) throws SQLException {
        return this.isPrivOrRoleGranted("SELECT ANY DICTIONARY") || this.isDataDictViewAccessible("DBA_" + baseName) ? "DBA_" + baseName : "ALL_" + baseName;
    }

    private Set<String> getAvailableOptions() throws SQLException {
        return new HashSet<String>(((DmConnection)this.getMainConnection()).getJdbcTemplate().queryForStringList("SELECT PARA_NAME FROM V$OPTION WHERE PARA_VALUE = 'TRUE'", new String[0]));
    }

    boolean isFlashbackDataArchiveAvailable() throws SQLException {
        return this.getAvailableOptions().contains("Flashback Data Archive");
    }

    boolean isXmlDbAvailable() throws SQLException {
        return this.isDataDictViewAccessible("ALL_XML_TABLES");
    }

    boolean isDataMiningAvailable() throws SQLException {
        return this.getAvailableOptions().contains("Data Mining");
    }

    boolean isLocatorAvailable() throws SQLException {
        return this.isDataDictViewAccessible("MDSYS", "ALL_SDO_GEOM_METADATA");
    }

    Set<String> getSystemSchemas() throws SQLException {
        HashSet<String> result = new HashSet<String>(Arrays.asList("SYS", "SYSTEM", "SYSBACKUP", "SYSDG", "SYSKM", "SYSRAC", "SYS$UMF", "DBSNMP", "MGMT_VIEW", "SYSMAN", "OUTLN", "AUDSYS", "ORACLE_OCM", "APPQOSSYS", "OJVMSYS", "DVF", "DVSYS", "DBSFWUSER", "REMOTE_SCHEDULER_AGENT", "DIP", "APEX_PUBLIC_USER", "FLOWS_FILES", "ANONYMOUS", "XDB", "XS$NULL", "CTXSYS", "LBACSYS", "EXFSYS", "MDDATA", "MDSYS", "SPATIAL_CSW_ADMIN_USR", "SPATIAL_WFS_ADMIN_USR", "ORDDATA", "ORDPLUGINS", "ORDSYS", "SI_INFORMTN_SCHEMA", "WMSYS", "OLAPSYS", "OWBSYS", "OWBSYS_AUDIT", "GSMADMIN_INTERNAL", "GSMCATUSER", "GSMUSER", "GGSYS", "WK_TEST", "WKSYS", "WKPROXY", "ODM", "ODM_MTR", "DMSYS", "TSMSYS"));
        result.addAll(((DmConnection)this.getMainConnection()).getJdbcTemplate().queryForStringList("SELECT USERNAME FROM ALL_USERS WHERE REGEXP_LIKE(USERNAME, '^(APEX|FLOWS)_\\d+$') OR DM_MAINTAINED = 'Y'", new String[0]));
        return result;
    }
}

