/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.dm;

import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.dm.DmDatabase;
import org.flywaydb.core.internal.database.dm.DmSchema;

public class DmConnection
extends org.flywaydb.core.internal.database.base.Connection<DmDatabase> {
    DmConnection(DmDatabase database, Connection connection) {
        super((Database)database, connection);
    }

    protected String getCurrentSchemaNameOrSearchPath() throws SQLException {
        return this.jdbcTemplate.queryForString("SELECT SYS_CONTEXT('USERENV', 'CURRENT_SCHEMA') FROM DUAL", new String[0]);
    }

    public void doChangeCurrentSchemaOrSearchPathTo(String schema) throws SQLException {
        this.jdbcTemplate.execute("ALTER SESSION SET CURRENT_SCHEMA=" + ((DmDatabase)this.database).quote(new String[]{schema}), new Object[0]);
    }

    public Schema getSchema(String name) {
        return new DmSchema(this.jdbcTemplate, (DmDatabase)this.database, name);
    }
}

