/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.core.util;

import cn.hutool.extra.servlet.ServletUtil;
import cn.hutool.http.Header;
import cn.hutool.http.useragent.UserAgent;
import cn.hutool.http.useragent.UserAgentUtil;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ServletContextUtil {
    public static boolean hasContext() {
        return RequestContextHolder.getRequestAttributes() != null;
    }

    public static UserAgent getUserAgent() {
        if (!ServletContextUtil.hasContext()) {
            return null;
        }
        UserAgent userAgent = UserAgentUtil.parse((String)ServletUtil.getHeader((HttpServletRequest)ServletContextUtil.getRequest(), (String)Header.USER_AGENT.getValue(), (Charset)StandardCharsets.UTF_8));
        return userAgent;
    }

    public static String getClientOS() {
        UserAgent userAgent = ServletContextUtil.getUserAgent();
        if (userAgent != null) {
            return userAgent.getPlatform().getName() + " " + userAgent.getOsVersion();
        }
        return "Unknown";
    }

    public static String getClientBrowser() {
        UserAgent userAgent = ServletContextUtil.getUserAgent();
        if (userAgent != null) {
            return userAgent.getBrowser().getName() + "(" + userAgent.getEngine().getName() + ")";
        }
        return "Unknown";
    }

    public static String getClientIp() {
        if (!ServletContextUtil.hasContext()) {
            return "Unknown";
        }
        return ServletUtil.getClientIP((HttpServletRequest)ServletContextUtil.getRequest(), (String[])new String[0]);
    }

    public static HttpServletRequest getRequest() {
        if (!ServletContextUtil.hasContext()) {
            return null;
        }
        return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
    }

    public static HttpServletResponse getResponse() {
        if (!ServletContextUtil.hasContext()) {
            return null;
        }
        HttpServletResponse response = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
        return response;
    }
}

