/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.core.util;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.format.DatePrinter;
import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.kdgcsoft.web.core.entity.BaseJob;
import com.kdgcsoft.web.core.entity.BaseJobLog;
import com.kdgcsoft.web.core.enums.JobLogStatus;
import com.kdgcsoft.web.core.job.IJob;
import com.kdgcsoft.web.core.service.BaseJobLogService;
import java.util.Date;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.util.StopWatch;

public class ScheduleJob
extends QuartzJobBean {
    private static final Logger log = LoggerFactory.getLogger(ScheduleJob.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        BaseJob baseJob = (BaseJob)context.getMergedJobDataMap().get((Object)"JOB_PARAM_KEY");
        BaseJobLogService jobLogService = (BaseJobLogService)((Object)SpringUtil.getBean(BaseJobLogService.class));
        BaseJobLog jobLog = new BaseJobLog();
        jobLog.setJobId(baseJob.getJobId());
        jobLog.setJobName(baseJob.getJobName());
        jobLog.setJobClass(baseJob.getJobClass());
        jobLog.setJobParam(baseJob.getJobParam());
        jobLog.setStartTime(new Date());
        StringBuilder jobInfo = new StringBuilder();
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            log.debug("\u4efb\u52a1\u51c6\u5907\u6267\u884c\uff0c\u4efb\u52a1\u540d\u79f0\uff1a" + baseJob.getJobName());
            jobInfo.append(DateUtil.format((Date)new Date(), (DatePrinter)DatePattern.NORM_DATETIME_MS_FORMAT));
            jobInfo.append("-\u4efb\u52a1\u5f00\u59cb").append("\r\n");
            Object target = SpringUtil.getBean(Class.forName(baseJob.getJobClass()));
            if (target != null) {
                jobInfo.append(DateUtil.format((Date)new Date(), (DatePrinter)DatePattern.NORM_DATETIME_MS_FORMAT));
                jobInfo.append("-\u5bfb\u627e\u5230\u4efb\u52a1\u6267\u884c\u7c7b:").append(target.getClass().getName()).append("\r\n");
                IJob iJob = (IJob)target;
                jobInfo.append(DateUtil.format((Date)new Date(), (DatePrinter)DatePattern.NORM_DATETIME_MS_FORMAT));
                jobInfo.append("-\u51c6\u5907\u6267\u884crun(String params)").append("\r\n");
                iJob.run(baseJob.getJobParam());
                stopWatch.stop();
                long seconds = stopWatch.getLastTaskTimeMillis();
                jobInfo.append(DateUtil.format((Date)new Date(), (DatePrinter)DatePattern.NORM_DATETIME_MS_FORMAT));
                jobInfo.append("-\u4efb\u52a1\u6267\u884c\u5b8c\u6210.\u8017\u65f6").append(seconds).append("ms").append("\r\n");
                jobLog.setTimeCost(seconds);
                jobLog.setJobStatus(JobLogStatus.SUCCESS);
                log.debug("\u4efb\u52a1\u6267\u884c\u5b8c\u6bd5\uff0c\u4efb\u52a1\u540d\u79f0\uff1a" + baseJob.getJobName());
            } else {
                stopWatch.stop();
                long seconds = stopWatch.getLastTaskTimeMillis();
                jobInfo.append(DateUtil.format((Date)new Date(), (DatePrinter)DatePattern.NORM_DATETIME_MS_FORMAT));
                jobInfo.append("-\u672a\u627e\u5230\u4efb\u52a1\u6267\u884c\u7c7b:").append(baseJob.getJobClass()).append("\r\n");
                jobInfo.append("-\u4efb\u52a1\u6267\u884c\u51fa\u9519:").append(baseJob.getJobClass()).append("\r\n");
                jobLog.setTimeCost(seconds);
                jobLog.setJobStatus(JobLogStatus.ERROR);
            }
        }
        catch (Exception e) {
            stopWatch.stop();
            long seconds = stopWatch.getLastTaskTimeMillis();
            log.error("\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff0c\u4efb\u52a1\u540d\u79f0\uff1a" + baseJob.getJobName(), (Throwable)e);
            jobInfo.append(DateUtil.format((Date)new Date(), (DatePrinter)DatePattern.NORM_DATETIME_MS_FORMAT));
            jobInfo.append("-\u4efb\u52a1\u6267\u884c\u51fa\u9519:").append(ExceptionUtil.stacktraceToString((Throwable)e, (int)-1)).append("\r\n");
            jobLog.setTimeCost(seconds);
            jobLog.setJobStatus(JobLogStatus.ERROR);
        }
        finally {
            jobLog.setExecInfo(jobInfo.toString());
            jobLog.setEndTime(new Date());
            jobLogService.save(jobLog);
        }
    }
}

