/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.core.service;

import com.kdgcsoft.web.core.entity.BaseRoleAuth;
import com.kdgcsoft.web.core.entity.table.BaseMenuAuthTableDef;
import com.kdgcsoft.web.core.entity.table.BaseMenuTableDef;
import com.kdgcsoft.web.core.entity.table.BaseRoleAuthTableDef;
import com.kdgcsoft.web.core.mapper.BaseRoleAuthMapper;
import com.kdgcsoft.web.core.service.BaseMenuAuthService;
import com.kdgcsoft.web.core.service.BaseMenuService;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.spring.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BaseRoleAuthService
extends ServiceImpl<BaseRoleAuthMapper, BaseRoleAuth> {
    @Autowired
    private BaseMenuService menuService;
    @Autowired
    private BaseMenuAuthService menuAuthService;

    @Transactional(rollbackFor={Exception.class})
    public void saveRoleAuth(String roleId, List<String> ids) {
        List menus = new ArrayList();
        List menuAuths = new ArrayList();
        if (!ids.isEmpty()) {
            menus = this.menuService.list(QueryWrapper.create().select(BaseMenuTableDef.BASE_MENU.ALL_COLUMNS).from(new QueryTable[]{BaseMenuTableDef.BASE_MENU}).where(BaseMenuTableDef.BASE_MENU.MENU_ID.in(ids)).and(BaseMenuTableDef.BASE_MENU.DELETED.eq((Object)0)));
            menuAuths = this.menuAuthService.list(QueryWrapper.create().select(BaseMenuAuthTableDef.BASE_MENU_AUTH.ALL_COLUMNS).from(new QueryTable[]{BaseMenuAuthTableDef.BASE_MENU_AUTH}).where(BaseMenuAuthTableDef.BASE_MENU_AUTH.AUTH_ID.in(ids)).and(BaseMenuAuthTableDef.BASE_MENU_AUTH.DELETED.eq((Object)0)));
        }
        this.remove(QueryWrapper.create().where(BaseRoleAuthTableDef.BASE_ROLE_AUTH.ROLE_ID.eq((Object)roleId)));
        ArrayList roleAuthList = new ArrayList();
        if (!menus.isEmpty()) {
            menus.forEach(menuAuth -> {
                BaseRoleAuth roleAuth = new BaseRoleAuth();
                roleAuth.setRoleId(roleId);
                roleAuth.setAuthId(menuAuth.getMenuId());
                roleAuth.setAuthCode(menuAuth.getMenuCode());
                roleAuth.setAuthType(menuAuth.getMenuType().name());
                roleAuthList.add(roleAuth);
            });
        }
        if (!menuAuths.isEmpty()) {
            menuAuths.forEach(menuAuth -> {
                BaseRoleAuth roleAuth = new BaseRoleAuth();
                roleAuth.setRoleId(roleId);
                roleAuth.setAuthId(menuAuth.getAuthId());
                roleAuth.setAuthCode(menuAuth.getAuthCode());
                roleAuth.setAuthType(menuAuth.getAuthType().name());
                roleAuthList.add(roleAuth);
            });
        }
        this.saveBatch(roleAuthList);
    }
}

