/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.core.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.web.config.security.SecurityUtil;
import com.kdgcsoft.web.core.entity.BaseOrg;
import com.kdgcsoft.web.core.entity.table.BaseOrgTableDef;
import com.kdgcsoft.web.core.mapper.BaseOrgMapper;
import com.kdgcsoft.web.core.util.TreeUtil;
import com.mybatisflex.core.query.If;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.row.Db;
import com.mybatisflex.spring.service.impl.ServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class BaseOrgService
extends ServiceImpl<BaseOrgMapper, BaseOrg> {
    public static final String CACHE_NAME = "BaseOrg";

    public List<BaseOrg> listBaseOrg() {
        BaseOrgTableDef a1 = BaseOrgTableDef.BASE_ORG.as("a1");
        BaseOrgTableDef a2 = BaseOrgTableDef.BASE_ORG.as("a2");
        QueryWrapper queryWrapper = QueryWrapper.create().select(a1.ALL_COLUMNS, a2.ORG_CODE.as("org_parent_code")).from(new QueryTable[]{a1}).leftJoin((QueryTable)a2).on(a1.ORG_PID.eq((Object)a2.ORG_ID)).where(BaseOrgTableDef.BASE_ORG.DELETED.eq((Object)0)).orderBy(BaseOrgTableDef.BASE_ORG.ORDER_NO, (Boolean)true);
        return Db.selectListByQueryAs(queryWrapper, BaseOrg.class);
    }

    @CacheEvict(value={"BaseOrg"}, allEntries=true)
    public BaseOrg saveBaseOrg(BaseOrg entity) {
        Assert.isFalse((boolean)this.hasRepeat(entity), (String)"\u7ec4\u7ec7\u673a\u6784\u7f16\u7801[{}]\u5df2\u5b58\u5728", (Object[])new Object[]{entity.getOrgCode()});
        this.saveOrUpdate(entity);
        return entity;
    }

    @CacheEvict(value={"BaseOrg"}, allEntries=true)
    public void deleteById(String id, boolean cascade) {
        if (cascade) {
            List<String> ids = TreeUtil.getChildIds(this.listBaseOrg(), id, true);
            this.removeByIds(ids);
        } else {
            this.removeById((Serializable)((Object)id));
        }
    }

    @Cacheable(value={"BaseOrg"}, key="#root.methodName+'.'+#rootNode")
    public List<BaseOrg> tree(boolean rootNode) {
        List<BaseOrg> list = this.listBaseOrg();
        List<BaseOrg> tree = TreeUtil.buildTree(list);
        if (rootNode) {
            BaseOrg root = new BaseOrg();
            root.setOrgId("0");
            root.setOrgName("\u6839\u8282\u70b9");
            root.setOrgFullName("\u6839\u8282\u70b9");
            root.setChildren(tree);
            return List.of(root);
        }
        return tree;
    }

    public List<String> getChildIds(String orgId, boolean include) {
        return TreeUtil.getChildIds(this.list(), orgId, true);
    }

    public List<BaseOrg> treeWithUser(boolean includeSelf) {
        String orgId = SecurityUtil.getUserOrgId();
        List<BaseOrg> list = this.listBaseOrg();
        BaseOrg currentOrg = (BaseOrg)CollUtil.findOne(list, baseOrg -> StrUtil.equals((CharSequence)baseOrg.getOrgId(), (CharSequence)orgId));
        if (currentOrg != null) {
            TreeUtil.buildTree(list);
            return includeSelf ? List.of(currentOrg) : currentOrg.getChildren();
        }
        if (SecurityUtil.isRoot()) {
            return TreeUtil.buildTree(list);
        }
        return new ArrayList<BaseOrg>();
    }

    public boolean hasRepeat(BaseOrg entity) {
        return this.exists(BaseOrgTableDef.BASE_ORG.ORG_CODE.eq((Object)entity.getOrgCode()).and(BaseOrgTableDef.BASE_ORG.ORG_ID.ne((Object)entity.getOrgId(), If::hasText)));
    }
}

