/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.core.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.fhs.trans.service.impl.DictionaryTransService;
import com.kdgcsoft.web.config.mvc.resolver.PageRequest;
import com.kdgcsoft.web.core.entity.BaseDict;
import com.kdgcsoft.web.core.entity.BaseDictItem;
import com.kdgcsoft.web.core.entity.table.BaseDictTableDef;
import com.kdgcsoft.web.core.enums.DictType;
import com.kdgcsoft.web.core.enums.YesNo;
import com.kdgcsoft.web.core.mapper.BaseDictMapper;
import com.kdgcsoft.web.core.service.BaseDictItemService;
import com.kdgcsoft.web.core.util.TreeUtil;
import com.mybatisflex.core.paginate.Page;
import com.mybatisflex.core.query.If;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.spring.service.impl.ServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BaseDictService
extends ServiceImpl<BaseDictMapper, BaseDict> {
    public static final String CACHE_NAME = "BaseDict";
    @Autowired
    BaseDictItemService dictItemService;
    @Autowired
    DictionaryTransService dictionaryTransService;

    public BaseDict findByCode(String dictCode) {
        BaseDict baseDict = (BaseDict)((BaseDictMapper)this.getMapper()).selectOneByQuery(new QueryWrapper().eq(BaseDict::getDictCode, (Object)dictCode));
        if (baseDict != null) {
            List<BaseDictItem> items = this.dictItemService.listByDictCode(baseDict.getDictCode());
            baseDict.setItems(TreeUtil.buildTree(items));
        }
        return baseDict;
    }

    public BaseDict findById(String id) {
        BaseDict baseDict = (BaseDict)this.getById((Serializable)((Object)id));
        if (baseDict != null) {
            List<BaseDictItem> items = this.dictItemService.listByDictCode(baseDict.getDictCode());
            baseDict.setItems(items);
        }
        return baseDict;
    }

    public List<BaseDict> listDict() {
        return ((BaseDictMapper)this.getMapper()).selectListByQuery(new QueryWrapper().orderBy(BaseDict::getDictName, (Boolean)true));
    }

    public Page<BaseDict> pageDict(PageRequest<BaseDict> page, YesNo embed, String searchKey) {
        QueryWrapper queryWrapper = QueryWrapper.create().where(BaseDictTableDef.BASE_DICT.DICT_CODE.like((Object)searchKey, If::hasText).or(BaseDictTableDef.BASE_DICT.DICT_NAME.like((Object)searchKey, If::hasText))).and(BaseDictTableDef.BASE_DICT.EMBED.eq((Object)embed)).orderBy(BaseDictTableDef.BASE_DICT.ID, (Boolean)false);
        return ((BaseDictMapper)this.getMapper()).paginate(page, queryWrapper);
    }

    @CacheEvict(value={"BaseDict"}, allEntries=true)
    @Transactional(rollbackFor={Exception.class})
    public BaseDict saveDict(BaseDict entity) {
        Assert.isFalse((boolean)this.hasRepeat(entity), (String)"\u5b57\u5178\u7f16\u7801[{}]\u5df2\u5b58\u5728", (Object[])new Object[]{entity.getDictCode()});
        Assert.isFalse((boolean)YesNo.Y.equals((Object)entity.getEmbed()), (String)"\u5185\u7f6e\u5b57\u5178\u4e0d\u53ef\u4fee\u6539", (Object[])new Object[0]);
        if (CollUtil.isNotEmpty(entity.getItems())) {
            entity.getItems().forEach(item -> item.setDictCode(entity.getDictCode()));
            List values = entity.getItems().stream().map(BaseDictItem::getValue).distinct().collect(Collectors.toList());
            Assert.isTrue((values.size() == entity.getItems().size() ? 1 : 0) != 0, (String)"\u5b57\u5178\u9879\u5b58\u5728\u91cd\u590d\u503c,\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        }
        List<BaseDictItem> dbItems = this.dictItemService.listByDictCode(entity.getDictCode());
        ArrayList removeItems = new ArrayList();
        dbItems.forEach(dbItem -> {
            BaseDictItem exist = (BaseDictItem)CollUtil.findOne(entity.getItems(), item -> StrUtil.equals((CharSequence)item.getId(), (CharSequence)dbItem.getId()));
            if (exist == null) {
                removeItems.add(dbItem.getId());
            }
        });
        this.dictItemService.removeByIds(removeItems);
        this.saveOrUpdate(entity);
        Assert.isFalse((boolean)StrUtil.isBlank((CharSequence)String.valueOf((Object)entity.getDictType())), (String)"\u5b57\u5178\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a", (Object[])new Object[0]);
        if (DictType.LIST.equals((Object)entity.getDictType())) {
            entity.getItems().forEach(item -> {
                if (item.getId().contains("TMP")) {
                    item.setId(null);
                }
            });
            this.dictItemService.saveOrUpdateBatch(entity.getItems());
        } else if (DictType.TREE.equals((Object)entity.getDictType())) {
            List<BaseDictItem> items = entity.getItems();
            List ids = items.stream().map(BaseDictItem::getId).collect(Collectors.toList());
            HashMap<String, String> pidMap = new HashMap<String, String>();
            while (!ids.isEmpty()) {
                List curRootList = items.stream().filter(item -> !ids.contains(item.getPid())).collect(Collectors.toList());
                for (BaseDictItem curRoot : curRootList) {
                    ids.remove(curRoot.getId());
                    if (curRoot.getId().contains("TMP")) {
                        String oldId = curRoot.getId();
                        curRoot.setId(null);
                        this.dictItemService.save(curRoot);
                        String newId = curRoot.getId();
                        pidMap.put(oldId, newId);
                        continue;
                    }
                    this.dictItemService.updateById(curRoot);
                }
                items.forEach(item -> {
                    if (StrUtil.isNotBlank((CharSequence)((CharSequence)pidMap.get(item.getPid())))) {
                        item.setPid((String)pidMap.get(item.getPid()));
                    }
                });
                pidMap.clear();
            }
        }
        this.refreshDictTransCache(entity.getDictCode());
        return entity;
    }

    @CacheEvict(value={"BaseDict"}, allEntries=true)
    @Transactional(rollbackFor={Exception.class})
    public void deleteByCode(String dictCode) {
        BaseDict entity = this.findByCode(dictCode);
        Assert.notNull((Object)entity, (String)"\u5b57\u5178[{}]\u4e0d\u5b58\u5728", (Object[])new Object[]{dictCode});
        Assert.isFalse((boolean)YesNo.Y.equals((Object)entity.getEmbed()), (String)"\u5185\u7f6e\u5b57\u5178\u4e0d\u53ef\u5220\u9664", (Object[])new Object[0]);
        this.removeById(entity);
        this.dictItemService.removeByDictCode(dictCode);
        this.dictionaryTransService.removeDictGroupAndNoticeOtherService(dictCode);
    }

    @CacheEvict(value={"BaseDict"}, allEntries=true)
    @Transactional(rollbackFor={Exception.class})
    public void deleteById(String id) {
        BaseDict entity = (BaseDict)this.getById((Serializable)((Object)id));
        Assert.notNull((Object)entity, (String)"\u5b57\u5178[{}]\u4e0d\u5b58\u5728", (Object[])new Object[]{id});
        Assert.isFalse((boolean)YesNo.Y.equals((Object)entity.getEmbed()), (String)"\u5185\u7f6e\u5b57\u5178\u4e0d\u53ef\u5220\u9664", (Object[])new Object[0]);
        this.removeById(entity);
        this.dictItemService.removeByDictCode(entity.getDictCode());
        this.dictionaryTransService.removeDictGroupAndNoticeOtherService(entity.getDictCode());
    }

    public boolean hasRepeat(BaseDict entity) {
        return this.exists(BaseDictTableDef.BASE_DICT.DICT_CODE.eq((Object)entity.getDictCode()).and(BaseDictTableDef.BASE_DICT.ID.ne((Object)entity.getId(), If::hasText)));
    }

    public void saveEmbedDict(BaseDict entity) {
        Assert.isFalse((boolean)this.hasRepeat(entity), (String)"\u5b57\u5178\u7f16\u7801[{}]\u5df2\u5b58\u5728", (Object[])new Object[]{entity.getDictCode()});
        this.saveOrUpdate(entity);
        this.dictItemService.removeByDictCode(entity.getDictCode());
        this.dictItemService.saveOrUpdateBatch(entity.getItems());
    }

    public List<BaseDict> listEmbedDicts() {
        return ((BaseDictMapper)this.getMapper()).selectListWithRelationsByQuery(new QueryWrapper().eq(BaseDict::getEmbed, (Object)YesNo.Y));
    }

    public List<BaseDict> allDictList() {
        return ((BaseDictMapper)this.getMapper()).selectListWithRelationsByQuery(new QueryWrapper());
    }

    @Cacheable(value={"BaseDict"}, key="#root.methodName+'.'+#dictCode+'.'+#value", unless="#result == null")
    public String getDictLabel(String dictCode, String value) {
        return this.dictItemService.getDictLabel(dictCode, value);
    }

    public void refreshDictTransCache(String dictCode) {
        BaseDict dict = (BaseDict)((BaseDictMapper)this.getMapper()).selectOneByQuery(new QueryWrapper().eq(BaseDict::getDictCode, (Object)dictCode));
        if (dict != null) {
            List<BaseDictItem> items = this.dictItemService.listByDictCode(dict.getDictCode());
            HashMap itemMap = new HashMap();
            CollUtil.forEach(items, (CollUtil.Consumer & Serializable)(item, index) -> itemMap.put(item.getValue(), item.getLabel()));
            this.dictionaryTransService.refreshCache(dict.getDictCode(), itemMap);
        }
    }
}

