/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.core.service;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.web.core.entity.BaseDictItem;
import com.kdgcsoft.web.core.entity.table.BaseDictItemTableDef;
import com.kdgcsoft.web.core.entity.table.BaseDictTableDef;
import com.kdgcsoft.web.core.mapper.BaseDictItemMapper;
import com.mybatisflex.core.query.If;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.spring.service.impl.ServiceImpl;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class BaseDictItemService
extends ServiceImpl<BaseDictItemMapper, BaseDictItem> {
    public boolean hasRepeat(BaseDictItem entity) {
        return this.exists(BaseDictItemTableDef.BASE_DICT_ITEM.DICT_CODE.eq((Object)entity.getDictCode()).and(BaseDictItemTableDef.BASE_DICT_ITEM.VALUE.eq((Object)entity.getValue())).and(BaseDictTableDef.BASE_DICT.ID.eq((Object)entity.getId(), If::hasText)));
    }

    public List<BaseDictItem> listByDictCode(String dictCode) {
        return this.list(new QueryWrapper().eq(BaseDictItem::getDictCode, (Object)dictCode).orderBy(BaseDictItem::getOrderNo, (Boolean)true));
    }

    public void removeByDictCode(String dictCode) {
        this.remove(BaseDictItemTableDef.BASE_DICT_ITEM.DICT_CODE.eq((Object)dictCode));
    }

    public String getDictLabel(String dictCode, String value) {
        if (StrUtil.isBlank((CharSequence)value)) {
            return null;
        }
        BaseDictItem item = (BaseDictItem)this.getOne(BaseDictItemTableDef.BASE_DICT_ITEM.DICT_CODE.eq((Object)dictCode).and(BaseDictItemTableDef.BASE_DICT_ITEM.VALUE.eq((Object)value)));
        if (item != null) {
            return item.getLabel();
        }
        return null;
    }

    public BaseDictItem saveDictItem(BaseDictItem entity) {
        BaseDictItem baseDictItem = (BaseDictItem)this.getOne(BaseDictItemTableDef.BASE_DICT_ITEM.DICT_CODE.eq((Object)entity.getDictCode()).and(BaseDictItemTableDef.BASE_DICT_ITEM.VALUE.eq((Object)entity.getValue())));
        Assert.isNull((Object)baseDictItem, (String)"\u5b57\u5178\u9879\u7f16\u7801\u91cd\u590d\uff01", (Object[])new Object[0]);
        this.save(entity);
        return entity;
    }

    public void deleteOne(String dictCode, String value) {
        this.remove(BaseDictItemTableDef.BASE_DICT_ITEM.DICT_CODE.eq((Object)dictCode).and(BaseDictItemTableDef.BASE_DICT_ITEM.VALUE.eq((Object)value)));
    }
}

