/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.core.service;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.web.core.entity.BaseDept;
import com.kdgcsoft.web.core.entity.table.BaseDeptTableDef;
import com.kdgcsoft.web.core.entity.table.BaseOrgTableDef;
import com.kdgcsoft.web.core.mapper.BaseDeptMapper;
import com.kdgcsoft.web.core.util.TreeUtil;
import com.mybatisflex.core.query.If;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.spring.service.impl.ServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class BaseDeptService
extends ServiceImpl<BaseDeptMapper, BaseDept> {
    public static final String CACHE_NAME = "BaseDept";

    public List<BaseDept> listByOrg(String orgId) {
        QueryWrapper queryWrapper = QueryWrapper.create().from(new QueryTable[]{BaseDeptTableDef.BASE_DEPT}).where(BaseDeptTableDef.BASE_DEPT.ORG_ID.eq((Object)orgId)).orderBy(BaseDeptTableDef.BASE_DEPT.ORDER_NO, (Boolean)true);
        return this.list(queryWrapper);
    }

    @CacheEvict(value={"BaseDept"}, allEntries=true)
    public void deleteById(String id, boolean cascade) {
        if (cascade) {
            List<String> ids = TreeUtil.getChildIds(this.list(), id, true);
            this.removeByIds(ids);
        } else {
            this.removeById((Serializable)((Object)id));
        }
    }

    public List<String> getChildIds(String deptId, boolean include) {
        return TreeUtil.getChildIds(this.list(), deptId, include);
    }

    @CacheEvict(value={"BaseDept"}, allEntries=true)
    public BaseDept saveBaseDept(BaseDept entity) {
        Assert.isFalse((boolean)this.hasRepeat(entity), (String)"\u90e8\u95e8\u7f16\u7801[{}]\u5df2\u5b58\u5728", (Object[])new Object[]{entity.getDeptCode()});
        this.saveOrUpdate(entity);
        return entity;
    }

    @Cacheable(value={"BaseDept"}, key="#root.methodName+'_'+#orgId+'_'+#rootNode")
    public List<BaseDept> tree(String orgId, boolean rootNode) {
        List<BaseDept> list = this.listByOrg(orgId);
        List<BaseDept> tree = TreeUtil.buildTree(list);
        if (rootNode) {
            BaseDept root = new BaseDept();
            root.setOrgId(orgId);
            root.setDeptId("0");
            root.setDeptName("\u6839\u8282\u70b9");
            root.setDeptFullName("\u6839\u8282\u70b9");
            root.setChildren(tree);
            return List.of(root);
        }
        return tree;
    }

    public boolean hasRepeat(BaseDept entity) {
        return this.exists(BaseDeptTableDef.BASE_DEPT.DEPT_CODE.eq((Object)entity.getDeptCode()).and(BaseDeptTableDef.BASE_DEPT.ORG_ID.eq((Object)entity.getOrgId())).and(BaseDeptTableDef.BASE_DEPT.DEPT_ID.ne((Object)entity.getDeptId(), If::hasText)));
    }

    public List<BaseDept> listDeptByOrgIds(String[] orgIds) {
        BaseDeptTableDef a1 = BaseDeptTableDef.BASE_DEPT.as("a1");
        BaseDeptTableDef a2 = BaseDeptTableDef.BASE_DEPT.as("a2");
        BaseOrgTableDef a3 = BaseOrgTableDef.BASE_ORG.as("a3");
        QueryWrapper queryWrapper = QueryWrapper.create().select(a1.ALL_COLUMNS, a2.DEPT_CODE.as("dept_parent_code"), a3.ORG_CODE).from(new QueryTable[]{a1}).leftJoin((QueryTable)a2).on(a1.DEPT_PID.eq((Object)a2.DEPT_ID)).leftJoin((QueryTable)a3).on(a1.ORG_ID.eq((Object)a3.ORG_ID)).orderBy(BaseDeptTableDef.BASE_DEPT.ORDER_NO, (Boolean)true);
        if (ArrayUtil.isNotEmpty((Object[])orgIds)) {
            queryWrapper.where(BaseDeptTableDef.BASE_DEPT.ORG_ID.in((Object[])orgIds));
        }
        return this.list(queryWrapper);
    }

    public List<String> getDeptLeaderByDeptId(String deptId) {
        BaseDept dept = (BaseDept)this.getById((Serializable)((Object)deptId));
        return StrUtil.split((CharSequence)dept.getManagerId(), (CharSequence)",");
    }

    public List<String> getDeptLeaderByDeptId2(String orgId, String deptId) {
        List<BaseDept> tree = this.tree(orgId, false);
        String managerId = this.findManagerId(deptId, tree);
        return StrUtil.split((CharSequence)managerId, (CharSequence)",");
    }

    public String findManagerId(String deptId, List<BaseDept> tree) {
        BaseDept dept = this.findDeptById(deptId, tree);
        while (dept != null) {
            if (dept.getManagerId() != null && !dept.getManagerId().isEmpty()) {
                return dept.getManagerId();
            }
            dept = this.findDeptById(dept.getDeptPid(), tree);
        }
        return null;
    }

    private BaseDept findDeptById(String deptId, List<BaseDept> tree) {
        for (BaseDept dept : tree) {
            if (deptId.equals(dept.getDeptId())) {
                return dept;
            }
            BaseDept found = this.findDeptById(deptId, dept.getChildren());
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public List<String> getParentAndChildDeptIds(String orgId, String deptId) {
        List<BaseDept> tree = this.tree(orgId, false);
        if (tree == null || tree.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<String, BaseDept> nodeMap = new HashMap<String, BaseDept>();
        this.buildNodeMap(tree, nodeMap);
        BaseDept topLevelNode = this.findTopLevelNode(nodeMap, deptId);
        if (topLevelNode == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        this.collectAllChildIds(topLevelNode, result);
        return result;
    }

    private void buildNodeMap(List<BaseDept> tree, Map<String, BaseDept> nodeMap) {
        for (BaseDept node : tree) {
            nodeMap.put(node.getDeptId(), node);
            this.buildNodeMap(node.getChildren(), nodeMap);
        }
    }

    private BaseDept findTopLevelNode(Map<String, BaseDept> nodeMap, String deptId) {
        BaseDept current = nodeMap.get(deptId);
        if (current == null) {
            return null;
        }
        while (!"0".equals(current.getDeptPid())) {
            if ((current = nodeMap.get(current.getDeptPid())) != null) continue;
            return null;
        }
        return current;
    }

    public BaseDept findTopLevelNode(String orgId, String deptId) {
        List<BaseDept> tree = this.tree(orgId, false);
        if (tree == null || tree.isEmpty()) {
            return (BaseDept)((Object)Collections.emptyList());
        }
        HashMap<String, BaseDept> nodeMap = new HashMap<String, BaseDept>();
        this.buildNodeMap(tree, nodeMap);
        BaseDept current = (BaseDept)nodeMap.get(deptId);
        if (current == null) {
            return null;
        }
        while (!"0".equals(current.getDeptPid())) {
            if ((current = (BaseDept)nodeMap.get(current.getDeptPid())) != null) continue;
            return null;
        }
        return current;
    }

    private void collectAllChildIds(BaseDept node, List<String> ids) {
        ids.add(node.getDeptId());
        for (BaseDept child : node.getChildren()) {
            this.collectAllChildIds(child, ids);
        }
    }
}

