/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.core.service;

import cn.dev33.satoken.exception.SaTokenException;
import cn.dev33.satoken.stp.StpUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.kdgcsoft.web.config.security.SecurityUtil;
import com.kdgcsoft.web.config.security.interfaces.AuthUser;
import com.kdgcsoft.web.config.security.interfaces.AuthUserInfo;
import com.kdgcsoft.web.config.security.interfaces.IAuthService;
import com.kdgcsoft.web.config.security.interfaces.LoginParams;
import com.kdgcsoft.web.config.security.interfaces.LoginResult;
import com.kdgcsoft.web.config.security.interfaces.LoginType;
import com.kdgcsoft.web.core.enums.AuthExceptionEnum;
import com.kdgcsoft.web.core.exception.BusinessException;
import com.kdgcsoft.web.core.util.ServletContextUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AuthService {
    private static final Logger log = LoggerFactory.getLogger(AuthService.class);

    public LoginResult login(LoginParams loginParams) {
        List<? extends AuthUser> accountList;
        LoginResult loginResult = new LoginResult();
        if (loginParams.getType() == null) {
            loginParams.setType(LoginType.ACCOUNT);
        }
        if (CollUtil.isEmpty(accountList = this.authentication(loginParams))) {
            throw new BusinessException(AuthExceptionEnum.ACCOUNT_ERROR.getValue(), new Object[0]);
        }
        if (accountList.size() > 1) {
            loginResult.setSuccess(false);
            loginResult.setAccountList(accountList);
            loginResult.setMsg("\u8fd4\u56de\u591a\u4e2a\u5339\u914d\u8d26\u53f7,\u8bf7\u9009\u62e9\u8981\u767b\u5f55\u7684\u8d26\u53f7");
        } else {
            AuthUser authUser = accountList.get(0);
            StpUtil.login((Object)authUser.getUserId(), (String)ServletContextUtil.getUserAgent().getPlatform().getName());
            IAuthService iAuthService = (IAuthService)SpringUtil.getBean(authUser.getAuthClass());
            AuthUserInfo authUserInfo = iAuthService.getAuthUserInfo(authUser);
            SecurityUtil.setUser(authUserInfo);
            loginResult.setSuccess(true);
            loginResult.setToken(StpUtil.getTokenInfo());
        }
        return loginResult;
    }

    private List<? extends AuthUser> authentication(LoginParams loginParams) {
        List<Object> authAccounts = new ArrayList();
        Map userServiceMap = SpringUtil.getBeansOfType(IAuthService.class);
        for (IAuthService loginUserService : userServiceMap.values()) {
            if (ArrayUtil.contains((Object[])loginUserService.supportedLoginTypes(), (Object)((Object)loginParams.getType()))) {
                try {
                    authAccounts = loginUserService.auth(loginParams);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    throw new SaTokenException(e.getMessage());
                }
            }
            if (!CollUtil.isNotEmpty(authAccounts)) continue;
            break;
        }
        return authAccounts;
    }

    public LoginResult ssoLogin(LoginType loginType, String ssoCode) {
        Assert.state((loginType == LoginType.SSO_USERID || loginType == LoginType.SSO_ACCOUNT || loginType == LoginType.SSO_EMP_NO ? 1 : 0) != 0, (String)"\u5355\u70b9\u767b\u5f55\u767b\u5f55\u65b9\u5f0f\u4e0d\u6b63\u786e", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)ssoCode, (String)"\u5355\u70b9\u767b\u5f55code\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        LoginParams loginParams = new LoginParams();
        loginParams.setType(loginType);
        loginParams.setSsoCode(ssoCode);
        LoginResult loginResult = this.login(loginParams);
        if (loginResult.isSuccess()) {
            return loginResult;
        }
        throw new BusinessException(loginResult.getMsg(), new Object[0]);
    }
}

