/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.core.controller;

import cn.hutool.core.collection.CollUtil;
import com.aizuda.monitor.DiskInfo;
import com.aizuda.monitor.OshiMonitor;
import com.kdgcsoft.web.core.pojo.Result;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import oshi.software.os.OSProcess;
import oshi.software.os.OperatingSystem;

@Tag(name="\u7cfb\u7edf\u76d1\u63a7")
@RestController
@Validated
@RequestMapping(value={"/base/monitor"})
public class BaseMonitorController {
    @Resource
    private OshiMonitor oshiMonitor;

    @Operation(summary="\u83b7\u53d6\u5b9e\u65f6\u6027\u80fd\u4fe1\u606f")
    @GetMapping(value={"/monitor"})
    public Result<Map<String, Object>> monitor() throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("sysInfo", this.oshiMonitor.getSysInfo());
        result.put("cpuInfo", this.oshiMonitor.getCpuInfo());
        result.put("memoryInfo", this.oshiMonitor.getMemoryInfo());
        result.put("jvmInfo", this.oshiMonitor.getJvmInfo());
        List diskInfos = this.oshiMonitor.getDiskInfos();
        result.put("diskInfos", diskInfos);
        if (CollUtil.isNotEmpty((Collection)diskInfos)) {
            long usableSpace = 0L;
            long totalSpace = 0L;
            for (DiskInfo diskInfo : diskInfos) {
                usableSpace += diskInfo.getUsableSpace().longValue();
                totalSpace += diskInfo.getTotalSpace().longValue();
            }
            double usedSize = totalSpace - usableSpace;
            result.put("diskUsePercent", Double.parseDouble(String.format("%.2f", this.oshiMonitor.formatDouble(usedSize / (double)totalSpace))));
        }
        List processes = this.oshiMonitor.getOperatingSystem().getProcesses(osProcess -> osProcess.getProcessID() > 0, OperatingSystem.ProcessSorting.CPU_DESC, 10);
        ArrayList processMapList = new ArrayList();
        int index = 1;
        for (OSProcess process : processes) {
            HashMap<String, Object> processMap = new HashMap<String, Object>(5);
            processMap.put("name", process.getName());
            processMap.put("pid", process.getProcessID());
            processMap.put("cpu", this.oshiMonitor.formatDouble(process.getProcessCpuLoadCumulative() * 100.0) + "%");
            processMap.put("index", index++);
            processMapList.add(processMap);
        }
        result.put("processes", processMapList);
        HashMap<String, Integer> threadCount = new HashMap<String, Integer>();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        threadCount.put("peak", threadMXBean.getPeakThreadCount());
        threadCount.put("active", threadMXBean.getThreadCount());
        threadCount.put("daemon", threadMXBean.getDaemonThreadCount());
        result.put("threadCount", threadCount);
        return Result.OK(result);
    }
}

