/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.core.advice;

import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.web.core.advice.GlobalExceptionResolver;
import com.kdgcsoft.web.core.enums.ErrorLevel;
import com.kdgcsoft.web.core.exception.BusinessException;
import com.kdgcsoft.web.core.pojo.Result;
import com.kdgcsoft.web.core.util.ServletContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.NoHandlerFoundException;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
public class GlobalControllerAdvice
implements ResponseBodyAdvice {
    private static final Logger log = LoggerFactory.getLogger(GlobalControllerAdvice.class);

    @ResponseBody
    @ExceptionHandler(value={BusinessException.class})
    public Result handleBusinessException(BusinessException e) {
        Result<Object> result = Result.ERROR(e.getMessage()).setCode(e.getErrorLevel().getCode()).setData(e.getData());
        if (e.getErrorLevel().equals((Object)ErrorLevel.ERROR)) {
            log.error(">>> [{}]\u8bf7\u6c42\u5f02\u5e38\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{},\u5f02\u5e38\u4fe1\u606f:{}", new Object[]{ServletContextUtil.getRequest().getMethod(), ServletContextUtil.getRequest().getRequestURL(), result.getMsg(), e});
        }
        return result;
    }

    @ResponseBody
    @ExceptionHandler(value={NoHandlerFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public Result handleException(NoHandlerFoundException e) {
        Result result = Result.ERROR(e.getMessage());
        log.error(">>> [{}]\u8bf7\u6c42\u5f02\u5e38\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{},\u5f02\u5e38\u4fe1\u606f:{}", new Object[]{ServletContextUtil.getRequest().getMethod(), ServletContextUtil.getRequest().getRequestURL(), result.getMsg(), e});
        return result;
    }

    @ResponseBody
    @ExceptionHandler(value={Throwable.class})
    public Result handleException(Exception e) {
        Result result = GlobalExceptionResolver.resolveException(e);
        log.error(">>> [{}]\u8bf7\u6c42\u5f02\u5e38\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{},\u5f02\u5e38\u4fe1\u606f:{}", new Object[]{ServletContextUtil.getRequest().getMethod(), ServletContextUtil.getRequest().getRequestURL(), result.getMsg(), e});
        return result;
    }

    public boolean supports(MethodParameter returnType, Class converterType) {
        return StrUtil.startWith((CharSequence)returnType.getDeclaringClass().getPackageName(), (CharSequence)"com.kdgcsoft");
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        if (body == null) {
            return Result.OK().setData(null);
        }
        if (body instanceof Result) {
            return body;
        }
        if (body instanceof Resource) {
            return body;
        }
        return Result.OK(body);
    }
}

