/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.config.security.user;

import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.web.config.BootProperties;
import com.kdgcsoft.web.config.security.interfaces.AuthUser;
import com.kdgcsoft.web.config.security.interfaces.AuthUserInfo;
import com.kdgcsoft.web.config.security.interfaces.IAuthService;
import com.kdgcsoft.web.config.security.interfaces.LoginParams;
import com.kdgcsoft.web.config.security.interfaces.LoginType;
import com.kdgcsoft.web.config.security.user.BaseAuthUserInfo;
import com.kdgcsoft.web.config.security.user.RootAuthUser;
import com.kdgcsoft.web.core.service.BaseMenuService;
import com.kdgcsoft.web.core.util.CryptoUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class RootAuthService
implements IAuthService {
    @Resource
    BootProperties bootProperties;
    @Resource
    BaseMenuService baseMenuService;

    @Override
    public LoginType[] supportedLoginTypes() {
        return new LoginType[]{LoginType.ACCOUNT};
    }

    @Override
    public List<? extends AuthUser> auth(LoginParams loginParams) {
        String rootUserName = this.bootProperties.getRootAccount();
        String rootPassword = this.bootProperties.getRootPassword();
        String decryptPassword = CryptoUtil.decryptFrontData(loginParams.getPassword());
        if (StrUtil.equals((CharSequence)rootUserName, (CharSequence)loginParams.getAccount()) && StrUtil.equals((CharSequence)rootPassword, (CharSequence)decryptPassword)) {
            RootAuthUser root = new RootAuthUser();
            root.setUserId(this.bootProperties.getRootAccountId());
            root.setUserName(this.bootProperties.getRootName());
            root.setOrgId(this.bootProperties.getRootOrgId());
            root.setOrgName(this.bootProperties.getRootName());
            root.setDeptId(this.bootProperties.getRootDeptId());
            root.setAuthClass(RootAuthService.class);
            return List.of(root);
        }
        return new ArrayList();
    }

    @Override
    public AuthUserInfo getAuthUserInfo(AuthUser authUser) {
        BaseAuthUserInfo authUserInfo = new BaseAuthUserInfo();
        authUserInfo.setAuthUser(authUser);
        authUserInfo.setMenus(this.baseMenuService.userMenuTree(authUser));
        return authUserInfo;
    }
}

