/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.config.mybatisflex.id;

import com.mybatisflex.core.keygen.IKeyGenerator;
import java.util.concurrent.ThreadLocalRandom;

public class FlexStrIDKeyGenerator
implements IKeyGenerator {
    private static final long INITIAL_TIMESTAMP = 1680411660000L;
    private static final long MAX_CLOCK_SEQ = 99L;
    private long lastTimeMillis = 0L;
    private long clockSeq = 0L;
    private long workId = 1L;

    public FlexStrIDKeyGenerator() {
    }

    public FlexStrIDKeyGenerator(long workId) {
        this.workId = workId;
    }

    public Object generate(Object entity, String keyColumn) {
        return String.valueOf(this.nextId());
    }

    private synchronized long nextId() {
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis == this.lastTimeMillis) {
            ++this.clockSeq;
            if (this.clockSeq > 99L) {
                this.clockSeq = 0L;
                ++currentTimeMillis;
            }
        } else if (currentTimeMillis < this.lastTimeMillis) {
            currentTimeMillis = this.lastTimeMillis;
            ++this.clockSeq;
            if (this.clockSeq > 99L) {
                this.clockSeq = 0L;
                ++currentTimeMillis;
            }
        } else {
            this.clockSeq = 0L;
        }
        this.lastTimeMillis = currentTimeMillis;
        long diffTimeMillis = currentTimeMillis - 1680411660000L;
        return diffTimeMillis * 1000000L + this.clockSeq * 10000L + this.workId * 100L + (long)this.getRandomInt();
    }

    private int getRandomInt() {
        return ThreadLocalRandom.current().nextInt(100);
    }
}

