/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.ac.utils;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.id.NanoId;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.web.ac.pojo.ModelRow;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ModelUtil {
    private static final char[] CUSTOM_ALPHABET = "0123456789abcdefghijkmnpqrstuvwxyz".toCharArray();
    public static final String TREE_LABEL = "label";
    public static final String TREE_VALUE = "value";
    public static final String CHILDREN = "children";

    public static String shortId(String prefix) {
        return StrUtil.format((CharSequence)"{}.{}", (Object[])new Object[]{prefix, NanoId.randomNanoId(null, (char[])CUSTOM_ALPHABET, (int)8)});
    }

    public static String shortId() {
        return NanoId.randomNanoId(null, (char[])CUSTOM_ALPHABET, (int)8);
    }

    public static List<ModelRow> toTree(List<ModelRow> list, String idField, String pidField) {
        if (CollUtil.isEmpty(list)) {
            return new ArrayList<ModelRow>();
        }
        List<ModelRow> tree = list.stream().filter(row -> row.get(pidField) == null || ObjectUtil.equals((Object)row.get(pidField), (Object)"0")).collect(Collectors.toList());
        ArrayList todoList = CollUtil.newArrayList(tree);
        while (!todoList.isEmpty()) {
            ModelRow todoNode = (ModelRow)((Object)todoList.get(0));
            todoList.remove(0);
            list.forEach(node -> {
                if (ObjectUtil.equals((Object)todoNode.get(idField), (Object)node.get(pidField))) {
                    if (todoNode.containsKey(CHILDREN)) {
                        ((List)todoNode.get(CHILDREN)).add(node);
                    } else {
                        todoNode.put(CHILDREN, CollUtil.newArrayList((Object[])new ModelRow[]{node}));
                    }
                    todoList.add(node);
                }
            });
        }
        return tree;
    }

    public static ModelRow findNodeById(List<ModelRow> tree, String idField, String pk) {
        if (CollUtil.isEmpty(tree)) {
            return null;
        }
        for (ModelRow node : tree) {
            if (ObjectUtil.equals((Object)node.get(idField), (Object)pk)) {
                return node;
            }
            ModelRow foundNode = ModelUtil.findNodeById((List)node.get(CHILDREN), idField, pk);
            if (foundNode == null) continue;
            return foundNode;
        }
        return null;
    }
}

