/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.ac.service;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.web.ac.entity.AcSerial;
import com.kdgcsoft.web.ac.mapper.AcSerialMapper;
import com.kdgcsoft.web.ac.pojo.ModelProConfig;
import com.kdgcsoft.web.ac.pojo.ModelRow;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.spring.service.impl.ServiceImpl;
import java.util.Date;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class AcSerialService
extends ServiceImpl<AcSerialMapper, AcSerial> {
    private static final Long DEFAULT_START_NO = 1L;

    public synchronized String genSerialNo(ModelProConfig.SerialField serialField, String modelCode, ModelRow modelRow) {
        String serialCode = serialField.getSerialCode(modelCode);
        AcSerial acSerial = (AcSerial)((AcSerialMapper)this.getMapper()).selectOneByQuery(QueryWrapper.create().eq(AcSerial::getSerialCode, (Object)serialCode).forUpdate());
        Long currentNo = NumberUtil.nullToZero((Long)serialField.getStartNo());
        if (acSerial == null) {
            acSerial = new AcSerial();
            acSerial.setSerialCode(serialField.getSerialCode(modelCode));
            acSerial.setCurrentNo(currentNo);
            this.save(acSerial);
        } else {
            currentNo = acSerial.getCurrentNo() + 1L;
            acSerial.setCurrentNo(currentNo);
            this.updateById(acSerial);
        }
        String formattedPrefix = StrUtil.format((CharSequence)serialField.getPrefix(), (Map)((Object)modelRow));
        formattedPrefix = formattedPrefix == null ? "" : formattedPrefix;
        String formattedTime = DateUtil.format((Date)DateUtil.date(), (String)serialField.getFormat().getFormat());
        formattedTime = formattedTime == null ? "" : formattedTime;
        String no = StrUtil.padPre((CharSequence)currentNo.toString(), (int)serialField.getDigit(), (CharSequence)"0");
        return StrUtil.format((CharSequence)"{}{}{}", (Object[])new Object[]{formattedPrefix, formattedTime, no});
    }
}

