/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.ac.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.SerializeUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.kdgcsoft.web.ac.entity.AcApp;
import com.kdgcsoft.web.ac.entity.AcModel;
import com.kdgcsoft.web.ac.entity.AcModelField;
import com.kdgcsoft.web.ac.entity.table.AcModelTableDef;
import com.kdgcsoft.web.ac.enums.EmbedFields;
import com.kdgcsoft.web.ac.enums.dict.ModelDataType;
import com.kdgcsoft.web.ac.enums.dict.ModelSyncStatus;
import com.kdgcsoft.web.ac.interfaces.ModelHandler;
import com.kdgcsoft.web.ac.mapper.AcModelMapper;
import com.kdgcsoft.web.ac.pojo.query.DataField;
import com.kdgcsoft.web.ac.pojo.query.DataModel;
import com.kdgcsoft.web.ac.pojo.query.FieldNature;
import com.kdgcsoft.web.ac.service.AcAppService;
import com.kdgcsoft.web.ac.service.AcModelFieldService;
import com.kdgcsoft.web.config.mvc.resolver.PageRequest;
import com.kdgcsoft.web.core.pojo.SelectOption;
import com.mybatisflex.core.paginate.Page;
import com.mybatisflex.core.query.If;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.row.Db;
import com.mybatisflex.spring.service.impl.ServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.anyline.metadata.Column;
import org.anyline.metadata.Metadata;
import org.anyline.metadata.Table;
import org.anyline.proxy.ServiceProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AcModelService
extends ServiceImpl<AcModelMapper, AcModel> {
    private static final Logger log = LoggerFactory.getLogger(AcModelService.class);
    public static final String CACHE_NAME = "AcModel";
    @Autowired
    private AcAppService acAppService;
    @Autowired
    private AcModelFieldService modelFieldService;

    public Page<AcModel> pageModel(PageRequest<AcModel> page, String appCode, String searchKey) {
        QueryWrapper queryWrapper = QueryWrapper.create().select().from(new QueryTable[]{AcModelTableDef.AC_MODEL}).where(AcModelTableDef.AC_MODEL.MODEL_CODE.like((Object)searchKey, If::hasText).or(AcModelTableDef.AC_MODEL.MODEL_NAME.like((Object)searchKey, If::hasText))).and(AcModelTableDef.AC_MODEL.APP_CODE.eq((Object)appCode, If::hasText));
        if (page.hasSorts()) {
            page.appendSortsToWrapper(queryWrapper);
        } else {
            queryWrapper.orderBy(AcModelTableDef.AC_MODEL.MODEL_CODE, (Boolean)true);
        }
        return this.page(page, queryWrapper);
    }

    public AcModel findByCode(String modelCode) {
        if (StrUtil.isNotBlank((CharSequence)modelCode)) {
            return (AcModel)((AcModelMapper)this.getMapper()).selectOneWithRelationsByQuery(QueryWrapper.create().eq(AcModel::getModelCode, (Object)modelCode));
        }
        return null;
    }

    public DataModel getDataModel(String modelCode) {
        DataModel cachedDataModel = ((AcModelService)((Object)SpringUtil.getBean(AcModelService.class))).buildDataModel(modelCode);
        DataModel clonedDataModel = (DataModel)SerializeUtil.clone((Object)cachedDataModel);
        return clonedDataModel;
    }

    @Cacheable(value={"AcModel"}, key="#root.methodName+'_'+#modelCode")
    public DataModel buildDataModel(String modelCode) {
        AcModel model = this.findByCode(modelCode);
        Assert.notNull((Object)model, (String)"\u6570\u636e\u6a21\u578b{}\u4e0d\u5b58\u5728", (Object[])new Object[]{modelCode});
        return DataModel.of(model);
    }

    public List<AcModel> findByIds(List<String> modelIds) {
        return this.list(AcModelTableDef.AC_MODEL.MODEL_ID.in(modelIds));
    }

    @CacheEvict(value={"AcModel"}, allEntries=true)
    @Transactional(rollbackFor={Exception.class})
    public AcModel saveModel(AcModel acModel) {
        acModel.buildAndValidate();
        this.checkRepeat(acModel);
        if (StrUtil.isBlank((CharSequence)acModel.getModelId())) {
            if (acModel.isImported()) {
                acModel.setSyncStatus(ModelSyncStatus.SYNCED);
                acModel.updateLastDbName();
            } else {
                acModel.setSyncStatus(ModelSyncStatus.UN_SYNCED);
            }
        } else {
            AcModel existModel = this.findByCode(acModel.getModelCode());
            Assert.notNull((Object)existModel, (String)"\u6570\u636e\u6a21\u578bid:{}\u4e0d\u5b58\u5728", (Object[])new Object[]{acModel.getModelId()});
            acModel.setSyncStatus(acModel.genSyncStatus(existModel));
            existModel.getFields().forEach(existField -> {
                if (!CollUtil.contains(acModel.getFields(), modelField -> StrUtil.equals((CharSequence)modelField.getFieldCode(), (CharSequence)existField.getFieldCode()))) {
                    this.modelFieldService.removeById((Serializable)((Object)existField.getFieldId()));
                }
            });
        }
        this.saveOrUpdate(acModel);
        this.modelFieldService.saveOrUpdateBatch(acModel.getFields());
        if (acModel.isImported()) {
            // empty if block
        }
        return acModel;
    }

    @CacheEvict(value={"AcModel"}, allEntries=true)
    @Transactional(rollbackFor={Exception.class})
    public AcModel importFromDb(AcModel acModel) {
        acModel.setFields(this.getFieldsFormDb(acModel.getTableName()));
        acModel.setImported(true);
        acModel.setDataType(ModelDataType.LIST);
        return this.saveModel(acModel);
    }

    public List<AcModelField> getFieldsFormDb(String tableName) {
        ArrayList<AcModelField> fields = new ArrayList<AcModelField>();
        Table table = ServiceProxy.metadata().table(tableName);
        if (table == null) {
            table = ServiceProxy.metadata().view(tableName);
        }
        Assert.notNull((Object)table, (String)"\u6570\u636e\u5e93\u8868[{}]\u4e0d\u5b58\u5728", (Object[])new Object[]{tableName});
        table.getColumns().values().forEach(o -> fields.add(AcModelField.fromDbColumn((Column)o)));
        return fields;
    }

    public void checkRepeat(AcModel acModel) {
        Assert.isFalse((boolean)this.exists(AcModelTableDef.AC_MODEL.MODEL_CODE.eq((Object)acModel.getModelCode()).and(AcModelTableDef.AC_MODEL.MODEL_ID.ne((Object)acModel.getModelId(), If::hasText))), (String)"\u6a21\u578b[{}]\u7f16\u7801[{}]\u91cd\u590d", (Object[])new Object[]{acModel.getModelName(), acModel.getModelCode()});
    }

    public List<SelectOption> getTableAndViews() {
        LinkedHashMap tableAndViewsMap = ServiceProxy.metadata().tables(Table.TYPE.VIEW.value);
        List tables = CollUtil.sort(tableAndViewsMap.values(), Comparator.comparing(Metadata::getName));
        List<SelectOption> optionList = tables.stream().map(table -> SelectOption.of(table.getName(), table.getName()).set("type", table.getType()).set("comment", table.getComment())).collect(Collectors.toList());
        return optionList;
    }

    public List<SelectOption> getTableAndViewsColumns() {
        LinkedHashMap tableLinkedHashMap = ServiceProxy.metadata().tables(Table.TYPE.VIEW.value);
        List tables = CollUtil.sort(tableLinkedHashMap.values(), Comparator.comparing(Metadata::getName));
        for (Table table2 : tables) {
            LinkedHashMap columns = ServiceProxy.metadata().columns(table2.getName());
            table2.setColumns(columns);
        }
        List<SelectOption> optionList = tables.stream().map(table -> SelectOption.of(table.getName(), table.getName()).set("type", table.getType()).set("comment", table.getComment()).set("columns", table.getColumns().values().stream().map(column -> ((Column)column).getName()).collect(Collectors.toList()))).collect(Collectors.toList());
        return optionList;
    }

    @CacheEvict(value={"AcModel"}, allEntries=true)
    @Transactional
    public void deleteModel(String modelId) {
        AcModel model = (AcModel)((AcModelMapper)this.getMapper()).selectOneWithRelationsById((Serializable)((Object)modelId));
        Assert.notNull((Object)model, (String)"\u6a21\u578bid[{}]\u4e0d\u5b58\u5728", (Object[])new Object[]{modelId});
        ((AcModelMapper)this.getMapper()).deleteById((Serializable)((Object)modelId));
        this.modelFieldService.removeByIds(model.getFields().stream().map(AcModelField::getFieldId).collect(Collectors.toList()));
    }

    public List<AcModelField> getEmbedFields() {
        ArrayList<AcModelField> fields = new ArrayList<AcModelField>();
        Arrays.stream(EmbedFields.values()).forEach(embedFields -> fields.add(EmbedFields.buildEmbedField(embedFields.getColName())));
        return fields;
    }

    public List<AcModel> listModel(List<String> appCodes) {
        return ((AcModelMapper)this.getMapper()).selectListWithRelationsByQuery(QueryWrapper.create().in(AcModel::getAppCode, appCodes, CollUtil.isNotEmpty(appCodes)).orderBy(AcModelTableDef.AC_MODEL.MODEL_CODE, (Boolean)true));
    }

    public List<SelectOption> groupModelByApp(String appCode) {
        ArrayList<SelectOption> optionList = new ArrayList<SelectOption>();
        if (StrUtil.isBlank((CharSequence)appCode)) {
            return optionList;
        }
        List<AcApp> apps = this.acAppService.getUsableApps(appCode);
        if (CollectionUtil.isNotEmpty(apps)) {
            List<String> appCodes = apps.stream().map(AcApp::getAppCode).collect(Collectors.toList());
            List<AcModel> models = this.listModel(appCodes);
            Map<String, List<AcModel>> mappedModels = models.stream().collect(Collectors.groupingBy(AcModel::getAppCode));
            apps.forEach(app -> {
                SelectOption groupOption = SelectOption.of(app.getAppCode(), app.getAppName());
                if (mappedModels.containsKey(app.getAppCode())) {
                    List modelList = (List)mappedModels.get(app.getAppCode());
                    groupOption.setOptions(modelList.stream().map(model -> SelectOption.of(model, model.getModelCode(), model.getModelName()).setFilter(model.getModelCode() + model.getModelName())).collect(Collectors.toList()));
                } else {
                    groupOption.setOptions(new ArrayList<SelectOption>());
                }
                optionList.add(groupOption);
            });
        }
        return optionList;
    }

    public List<SelectOption> cascadeFields(String appCode) {
        ArrayList<SelectOption> optionList = new ArrayList<SelectOption>();
        if (StrUtil.isBlank((CharSequence)appCode)) {
            return optionList;
        }
        List<AcApp> apps = this.acAppService.getUsableApps(appCode);
        List<String> appCodes = apps.stream().map(AcApp::getAppCode).collect(Collectors.toList());
        List<AcModel> models = this.listModel(appCodes);
        models.forEach(model -> {
            SelectOption groupOption = SelectOption.of(model.getModelCode(), model.getModelName());
            groupOption.setChildren(model.getNormalFields().stream().map(field -> SelectOption.of(field, field.getFieldKey(), field.getFieldName())).collect(Collectors.toList()));
            optionList.add(groupOption);
        });
        return optionList;
    }

    @Cacheable(value={"AcModel"}, key="#root.methodName+'_'+#modelCode+'_'+#trans+'_'+#embed")
    public List<SelectOption> listFieldsByCode(String modelCode, Boolean trans, Boolean embed) {
        AcModelService modelService = (AcModelService)((Object)SpringUtil.getBean(AcModelService.class));
        DataModel dataModel = modelService.getDataModel(modelCode);
        Assert.notNull((Object)dataModel, (String)"\u6570\u636e\u6a21\u578b[{}]\u4e0d\u5b58\u5728", (Object[])new Object[]{modelCode});
        List<DataField> fieldList = dataModel.getQueryFields();
        if (!trans.booleanValue()) {
            fieldList = fieldList.stream().filter(field -> field.getFieldNature() != FieldNature.TRANS).collect(Collectors.toList());
        }
        if (!embed.booleanValue()) {
            fieldList = fieldList.stream().filter(field -> !field.isEmbed()).collect(Collectors.toList());
        }
        ArrayList<SelectOption> selectList = new ArrayList<SelectOption>();
        fieldList.forEach(field -> selectList.add(field.toSelectOption()));
        return selectList;
    }

    public List<SelectOption> queryFieldList(String modelCode) {
        AcModelService modelService = (AcModelService)((Object)SpringUtil.getBean(AcModelService.class));
        DataModel dataModel = modelService.getDataModel(modelCode);
        Assert.notNull((Object)dataModel, (String)"\u6570\u636e\u6a21\u578b[{}]\u4e0d\u5b58\u5728", (Object[])new Object[]{modelCode});
        List<DataField> fieldList = dataModel.getQueryFields();
        fieldList = fieldList.stream().filter(field -> !field.isEmbed()).collect(Collectors.toList());
        ArrayList<SelectOption> selectList = new ArrayList<SelectOption>();
        fieldList.forEach(field -> selectList.add(SelectOption.of(field.getAlias(), field.getFieldName()).setFilter(field.getAlias() + field.getFieldName())));
        return selectList;
    }

    public List<SelectOption> modelFormFieldList(String modelCode) {
        AcModelService modelService = (AcModelService)((Object)SpringUtil.getBean(AcModelService.class));
        DataModel dataModel = modelService.getDataModel(modelCode);
        Assert.notNull((Object)dataModel, (String)"\u6570\u636e\u6a21\u578b[{}]\u4e0d\u5b58\u5728", (Object[])new Object[]{modelCode});
        List<DataField> fieldList = dataModel.getNativeFields();
        fieldList = fieldList.stream().filter(field -> !field.isEmbed()).collect(Collectors.toList());
        ArrayList<SelectOption> selectList = new ArrayList<SelectOption>();
        fieldList.forEach(field -> selectList.add(field.toSelectOption()));
        dataModel.getRefSubModelMap().forEach((key, value) -> selectList.add(SelectOption.of(value.getRefAlias(), value.getDataModel().getModelName()).setFilter(value.getRefAlias() + value.getDataModel().getModelName()).set("subModel", true)));
        return selectList;
    }

    public List<SelectOption> getModelServiceList() {
        ArrayList<SelectOption> serviceList = new ArrayList<SelectOption>();
        SpringUtil.getBeansOfType(ModelHandler.class).forEach((name, service) -> serviceList.add(SelectOption.of(AopUtils.getTargetClass((Object)service).getName(), name)));
        return serviceList;
    }

    public String transModelDataLabel(String modelCode, String keyValue) {
        AcModel acModel = this.findByCode(modelCode);
        if (acModel != null && acModel.isCacheEnable()) {
            AcModelField keyField = acModel.cacheKeyField();
            AcModelField labelField = acModel.cacheLabelField();
            if (keyField != null && labelField != null) {
                QueryWrapper qw = QueryWrapper.create().select(labelField.getColName()).from(acModel.getTableName()).eq(keyField.getColName(), (Object)keyValue);
                Object o = Db.selectObject(qw);
                return o == null ? null : Convert.toStr((Object)o);
            }
            log.warn("\u6a21\u578b[{}]\u6570\u636e\u7f13\u5b58\u5b57\u6bb5\u672a\u914d\u7f6e,\u65e0\u6cd5\u7ffb\u8bd1", (Object)modelCode);
            return null;
        }
        log.warn("\u6a21\u578b[{}]\u4e0d\u5b58\u5728\u6216\u672a\u5f00\u542f\u6570\u636e\u7f13\u5b58,\u65e0\u6cd5\u7ffb\u8bd1", (Object)modelCode);
        return null;
    }

    public List<AcModel> exportByAppCode(String appCode) {
        return ((AcModelMapper)this.getMapper()).selectListWithRelationsByQuery(QueryWrapper.create().eq(AcModel::getAppCode, (Object)appCode));
    }

    public String importModels(List<AcModel> models) {
        int insertCount = 0;
        int updateCount = 0;
        if (CollectionUtil.isNotEmpty(models)) {
            List modelCodeList = models.stream().map(AcModel::getModelCode).collect(Collectors.toList());
            List dbModelList = this.list(QueryWrapper.create().in(AcModel::getModelCode, modelCodeList));
            Map dbModelMap = dbModelList.stream().collect(Collectors.toMap(AcModel::getModelCode, Function.identity()));
            for (AcModel model : models) {
                AcModel dbModel = (AcModel)dbModelMap.get(model.getModelCode());
                if (dbModel == null) {
                    model.setModelId(null);
                    model.setSyncStatus(ModelSyncStatus.UN_SYNCED);
                    model.getFields().forEach(field -> field.setFieldId(null));
                    ++insertCount;
                } else {
                    model.setModelId(dbModel.getModelId());
                    List fields = this.modelFieldService.list(QueryWrapper.create().eq(AcModelField::getModelCode, (Object)model.getModelCode()));
                    dbModel.setFields(fields);
                    model.setSyncStatus(model.genSyncStatus(dbModel));
                    model.updateLastDbName();
                    dbModel.getFields().forEach(existField -> {
                        if (!CollUtil.contains(model.getFields(), modelField -> StrUtil.equals((CharSequence)modelField.getFieldCode(), (CharSequence)existField.getFieldCode()))) {
                            this.modelFieldService.removeById((Serializable)((Object)existField.getFieldId()));
                        }
                    });
                    model.getFields().forEach(field -> {
                        AcModelField dbField = dbModel.getFieldByCode(field.getFieldCode());
                        field.setFieldId(dbField == null ? null : dbField.getFieldId());
                    });
                    ++updateCount;
                }
                this.saveOrUpdate(model);
                this.modelFieldService.saveOrUpdateBatch(model.getFields());
            }
        }
        if (insertCount + updateCount == 0) {
            return null;
        }
        return String.format("\u5bfc\u5165\u6a21\u578b %d \u4e2a\uff1a\u65b0\u589e %d \u4e2a\uff0c\u66f4\u65b0 %d \u4e2a", insertCount + updateCount, insertCount, updateCount);
    }
}

