/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.ac.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.web.ac.entity.AcApp;
import com.kdgcsoft.web.ac.entity.AcDataset;
import com.kdgcsoft.web.ac.entity.table.AcDatasetTableDef;
import com.kdgcsoft.web.ac.enums.DatasetType;
import com.kdgcsoft.web.ac.enums.Order;
import com.kdgcsoft.web.ac.mapper.AcDatasetMapper;
import com.kdgcsoft.web.ac.pojo.ModelRow;
import com.kdgcsoft.web.ac.pojo.dataset.DatasetConfig;
import com.kdgcsoft.web.ac.pojo.dataset.DatasetModel;
import com.kdgcsoft.web.ac.pojo.dataset.DatasetParams;
import com.kdgcsoft.web.ac.pojo.dataset.ModelQueryBuilder;
import com.kdgcsoft.web.ac.pojo.query.DataField;
import com.kdgcsoft.web.ac.pojo.query.DataModel;
import com.kdgcsoft.web.ac.pojo.query.GridModelData;
import com.kdgcsoft.web.ac.service.AcAppService;
import com.kdgcsoft.web.ac.service.AcModelService;
import com.kdgcsoft.web.ac.utils.ModelUtil;
import com.kdgcsoft.web.config.mvc.resolver.PageRequest;
import com.kdgcsoft.web.core.pojo.SelectOption;
import com.mybatisflex.core.constant.SqlOperator;
import com.mybatisflex.core.paginate.Page;
import com.mybatisflex.core.query.FunctionQueryColumn;
import com.mybatisflex.core.query.If;
import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.query.QueryCondition;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.row.Db;
import com.mybatisflex.core.row.Row;
import com.mybatisflex.spring.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ibatis.builder.xml.XMLMapperEntityResolver;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.parsing.XPathParser;
import org.apache.ibatis.scripting.xmltags.XMLScriptBuilder;
import org.apache.ibatis.session.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.xml.sax.EntityResolver;

@Service
public class AcDatasetService
extends ServiceImpl<AcDatasetMapper, AcDataset> {
    private static final Logger log = LoggerFactory.getLogger(AcDatasetService.class);
    public static final String CACHE_NAME = "AcDataset";
    String EMPTY_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<!DOCTYPE configuration\r\n PUBLIC \"-//mybatis.org//DTD Config 3.0//EN\"\r\n \"http://mybatis.org/dtd/mybatis-3-config.dtd\">\r\n<configuration>\r\n</configuration>";
    @Autowired
    private AcAppService acAppService;
    @Autowired
    private AcModelService modelService;

    @Cacheable(value={"AcDataset"}, key="#root.methodName+'_'+#datasetCode")
    public AcDataset findByCode(String datasetCode) {
        Assert.notBlank((CharSequence)datasetCode, (String)"\u6570\u636e\u96c6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return (AcDataset)((AcDatasetMapper)this.getMapper()).selectOneByQuery(QueryWrapper.create().eq(AcDataset::getDatasetCode, (Object)datasetCode));
    }

    public DatasetModel getDatasetModel(String datasetCode) {
        AcDataset acDataset = this.findByCode(datasetCode);
        if (acDataset != null) {
            return DatasetModel.of(acDataset);
        }
        return null;
    }

    @CacheEvict(value={"AcDataset"}, allEntries=true)
    public void saveDataset(AcDataset entity) {
        if (StrUtil.isBlank((CharSequence)entity.getDatasetCode())) {
            entity.setDatasetCode(ModelUtil.shortId("dataset"));
        }
        this.saveOrUpdate(entity);
    }

    public boolean hasRepeat(AcDataset entity) {
        QueryWrapper wrapper = QueryWrapper.create();
        wrapper.from(new QueryTable[]{AcDatasetTableDef.AC_DATASET});
        wrapper.and(AcDatasetTableDef.AC_DATASET.DATASET_CODE.eq((Object)entity.getDatasetCode()).and(AcDatasetTableDef.AC_DATASET.DATASET_ID.ne((Object)entity.getDatasetId(), If::hasText)));
        return ((AcDatasetMapper)this.getMapper()).selectCountByQuery(wrapper) > 0L;
    }

    public Page<AcDataset> pageDataset(PageRequest<AcDataset> page, String appCode, String searchKey) {
        QueryWrapper queryWrapper = QueryWrapper.create().select().from(new QueryTable[]{AcDatasetTableDef.AC_DATASET}).where(AcDatasetTableDef.AC_DATASET.DATASET_CODE.like((Object)searchKey, If::hasText).or(AcDatasetTableDef.AC_DATASET.DATASET_NAME.like((Object)searchKey, If::hasText))).and(AcDatasetTableDef.AC_DATASET.APP_CODE.eq((Object)appCode, If::hasText));
        if (page.hasSorts()) {
            page.appendSortsToWrapper(queryWrapper);
        } else {
            queryWrapper.orderBy(AcDatasetTableDef.AC_DATASET.DATASET_CODE, (Boolean)true);
        }
        return this.page(page, queryWrapper);
    }

    public List<AcDataset> listDataset(List<String> appCodes) {
        return ((AcDatasetMapper)this.getMapper()).selectListByQuery(QueryWrapper.create().in(AcDataset::getAppCode, appCodes, CollUtil.isNotEmpty(appCodes)).orderBy(AcDatasetTableDef.AC_DATASET.DATASET_CODE, (Boolean)true));
    }

    public List<SelectOption> groupDatasetByApp(String appCode) {
        ArrayList<SelectOption> optionList = new ArrayList<SelectOption>();
        if (StrUtil.isBlank((CharSequence)appCode)) {
            return optionList;
        }
        List<AcApp> apps = this.acAppService.getUsableApps(appCode);
        List<String> appCodes = apps.stream().map(AcApp::getAppCode).collect(Collectors.toList());
        List<AcDataset> models = this.listDataset(appCodes);
        Map<String, List<AcDataset>> mappedModels = models.stream().collect(Collectors.groupingBy(AcDataset::getAppCode));
        apps.forEach(app -> {
            SelectOption groupOption = SelectOption.of(app.getAppCode(), app.getAppName());
            if (mappedModels.containsKey(app.getAppCode())) {
                List modelList = (List)mappedModels.get(app.getAppCode());
                groupOption.setOptions(modelList.stream().map(model -> SelectOption.of(model, model.getDatasetCode(), model.getDatasetName()).setFilter(model.getDatasetCode() + model.getDatasetName())).collect(Collectors.toList()));
            } else {
                groupOption.setOptions(new ArrayList<SelectOption>());
            }
            optionList.add(groupOption);
        });
        return optionList;
    }

    public List<SelectOption> getFieldList(String datasetCode) {
        DatasetModel datasetModel = this.getDatasetModel(datasetCode);
        Assert.notNull((Object)"\u6570\u636e\u96c6{}\u672a\u627e\u5230", (String)datasetCode, (Object[])new Object[0]);
        if (CollUtil.isNotEmpty(datasetModel.getDatasetFields())) {
            return datasetModel.getDatasetFields().stream().map(field -> SelectOption.of(field.getField(), field.getTitle())).collect(Collectors.toList());
        }
        return new ArrayList<SelectOption>();
    }

    public GridModelData getDatasetData(DatasetParams datasetParams) {
        return this.getDatasetData(datasetParams, false);
    }

    public GridModelData getDatasetData(DatasetParams datasetParams, boolean preview) {
        Assert.notNull((Object)datasetParams.getDataset(), (String)"\u6570\u636e\u96c6\u4e3a\u7a7a", (Object[])new Object[0]);
        DatasetConfig datasetConfig = datasetParams.getDataset().getDatasetConfig();
        Assert.notNull((Object)datasetConfig, (String)"\u6570\u636e\u96c6\u914d\u7f6e\u4e3a\u7a7a", (Object[])new Object[0]);
        if (datasetConfig.getType() == DatasetType.MODEL) {
            return this.getModelQueryData(datasetConfig, datasetParams.getParams(), preview);
        }
        if (datasetConfig.getType() == DatasetType.SQL) {
            return this.getSqlQueryData(datasetConfig, datasetParams.getParams(), preview);
        }
        if (datasetConfig.getType() == DatasetType.API) {
            return this.getApiQueryData(datasetConfig, datasetParams.getParams(), preview);
        }
        return new GridModelData();
    }

    private GridModelData getModelQueryData(DatasetConfig datasetConfig, Map<String, String> params, boolean preview) {
        GridModelData gridModelData = new GridModelData();
        if (CollUtil.isNotEmpty(datasetConfig.getParams())) {
            for (DatasetConfig.DatasetParam param : datasetConfig.getParams()) {
                if (!param.isRequired() || params.containsKey(param.getCode())) continue;
                return gridModelData;
            }
        }
        ModelQueryBuilder builder = datasetConfig.getBuilder();
        HashMap<String, DataModel> modelMap = new HashMap<String, DataModel>();
        DataModel main = this.modelService.getDataModel(builder.getMain().getModelCode());
        main.setAlias(builder.getMain().getAlias());
        modelMap.put(builder.getMain().getTableKey(), main);
        QueryWrapper queryWrapper = QueryWrapper.create().from(main.table());
        builder.getJoins().forEach(join -> {
            DataModel joinModel = this.modelService.getDataModel(join.getModelCode());
            joinModel.setAlias(join.getAlias());
            modelMap.put(join.getTableKey(), joinModel);
            DataField mField = main.getNativeFieldByCode(join.getMainField());
            DataField joinField = joinModel.getNativeFieldByCode(join.getJoinField());
            QueryCondition queryCondition = mField.column().eq((Object)joinField.column()).and(joinModel.getLogicField().column().eq((Object)0, joinModel.hasLogicDelete()));
            queryWrapper.leftJoin(joinModel.table()).on(queryCondition);
        });
        builder.getFields().forEach(field -> {
            DataField queryField;
            DataModel dataModel = (DataModel)modelMap.get(field.getTableKey());
            if (dataModel != null && (queryField = dataModel.getNativeFieldByCode(field.getFieldCode())) != null) {
                QueryColumn column = queryField.column();
                if (field.getFunc() != null) {
                    QueryColumn cloneCol = queryField.column().clone();
                    cloneCol.setAlias("");
                    column = new FunctionQueryColumn(field.getFunc().getFuncName(), new QueryColumn[]{cloneCol});
                }
                String colName = StrUtil.blankToDefault((CharSequence)field.getAlias(), (String)queryField.getFieldCode());
                column.setAlias(colName);
                queryWrapper.select(column);
                GridModelData.GridColumn col = new GridModelData.GridColumn(colName, StrUtil.format((CharSequence)"{}({})", (Object[])new Object[]{queryField.getFieldName(), colName}));
                gridModelData.addColumn(col);
            }
        });
        QueryCondition allQueryCondition = QueryCondition.createEmpty();
        builder.getConditions().forEach(cond -> {
            DataModel condModel = (DataModel)modelMap.get(cond.getTableKey());
            if (condModel != null) {
                DataField leftField = condModel.getNativeFieldByCode(cond.getFieldCode());
                QueryCondition queryCondition = QueryCondition.createEmpty();
                switch (cond.getType()) {
                    case FIELD: {
                        DataModel rightModel = (DataModel)modelMap.get(cond.getRightTableKey());
                        if (rightModel != null) {
                            DataField rightField = rightModel.getNativeFieldByCode(cond.getRightFieldCode());
                            if (rightField == null) break;
                            queryCondition = QueryCondition.create((QueryColumn)leftField.column(), (SqlOperator)cond.getCondition().getOperator(), (Object)rightField.column());
                            break;
                        }
                        log.warn("\u5b57\u6bb5{}\u4e0d\u5b58\u5728,\u5ffd\u7565\u67e5\u8be2\u6761\u4ef6");
                        break;
                    }
                    case PARAM: {
                        if (!StrUtil.isNotBlank((CharSequence)cond.getValue()) || !params.containsKey(cond.getValue())) break;
                        queryCondition = QueryCondition.create((QueryColumn)leftField.column(), (SqlOperator)cond.getCondition().getOperator(), (Object)leftField.getFieldType().toDbValue((String)params.get(cond.getValue())));
                        break;
                    }
                    case FIXED_VALUE: {
                        if (!StrUtil.isNotBlank((CharSequence)cond.getValue())) break;
                        queryCondition = QueryCondition.create((QueryColumn)leftField.column(), (SqlOperator)cond.getCondition().getOperator(), (Object)leftField.getFieldType().toDbValue((String)params.get(cond.getValue())));
                        break;
                    }
                    default: {
                        queryCondition = QueryCondition.createEmpty();
                    }
                }
                allQueryCondition.and(queryCondition);
            }
        });
        queryWrapper.where(allQueryCondition);
        builder.getGroups().forEach(group -> {
            DataField groupField;
            DataModel groupModel = (DataModel)modelMap.get(group.getTableKey());
            if (groupModel != null && (groupField = groupModel.getNativeFieldByCode(group.getFieldCode())) != null) {
                queryWrapper.groupBy(groupField.column());
            }
        });
        builder.getOrders().forEach(order -> {
            DataField orderField;
            DataModel orderModel = (DataModel)modelMap.get(order.getTableKey());
            if (orderModel != null && (orderField = orderModel.getNativeFieldByCode(order.getFieldCode())) != null) {
                queryWrapper.orderBy(orderField.column(), (Boolean)(order.getOrder() == Order.ASC ? 1 : 0));
            }
        });
        if (preview) {
            queryWrapper.limit(50);
        }
        List<Row> list = Db.selectListByQuery(queryWrapper);
        List<ModelRow> rowList = list.stream().map(row -> ModelRow.of(row)).collect(Collectors.toList());
        gridModelData.setData(rowList);
        return gridModelData;
    }

    private GridModelData getSqlQueryData(DatasetConfig datasetConfig, Map<String, String> params, boolean preview) {
        GridModelData gridModelData = new GridModelData();
        String script = "<script>" + datasetConfig.getSql() + "</script>";
        XPathParser parser = new XPathParser(script, false, new Properties(), (EntityResolver)new XMLMapperEntityResolver());
        XMLScriptBuilder builder = new XMLScriptBuilder(new Configuration(), parser.evalNode("/script"), Map.class);
        SqlSource sqlSource = builder.parseScriptNode();
        BoundSql boundSql = sqlSource.getBoundSql(params);
        List list = Db.selectListBySql(boundSql.getSql(), params);
        if (preview) {
            list = CollUtil.sub(list, (int)0, (int)20);
        }
        if (CollUtil.isNotEmpty(list)) {
            Row firstRow = (Row)list.get(0);
            firstRow.toCamelKeysMap().keySet().forEach(colName -> gridModelData.addColumn(new GridModelData.GridColumn((String)colName, (String)colName)));
        }
        List<ModelRow> rowList = list.stream().map(row -> ModelRow.of(row)).collect(Collectors.toList());
        gridModelData.setData(rowList);
        return gridModelData;
    }

    private GridModelData getApiQueryData(DatasetConfig datasetConfig, Map<String, String> params, boolean preview) {
        GridModelData gridModelData = new GridModelData();
        return gridModelData;
    }

    public List<AcDataset> exportByAppCode(String appCode) {
        return ((AcDatasetMapper)this.getMapper()).selectListByQuery(QueryWrapper.create().eq(AcDataset::getAppCode, (Object)appCode));
    }

    public String importDatasets(List<AcDataset> datasets) {
        int insertCount = 0;
        int updateCount = 0;
        if (CollectionUtil.isNotEmpty(datasets)) {
            List datasetCodeList = datasets.stream().map(AcDataset::getDatasetCode).collect(Collectors.toList());
            List dbDatasetList = this.list(QueryWrapper.create().in(AcDataset::getDatasetCode, datasetCodeList));
            Map dbDatasetMap = dbDatasetList.stream().collect(Collectors.toMap(AcDataset::getDatasetCode, Function.identity()));
            for (AcDataset dataset : datasets) {
                AcDataset dbDataset = (AcDataset)dbDatasetMap.get(dataset.getDatasetCode());
                if (dbDataset == null) {
                    dataset.setDatasetId(null);
                    ++insertCount;
                } else {
                    dataset.setDatasetId(dbDataset.getDatasetId());
                    ++updateCount;
                }
                this.saveOrUpdate(dataset);
            }
        }
        if (insertCount + updateCount == 0) {
            return null;
        }
        return String.format("\u5bfc\u5165\u6570\u636e\u96c6 %d \u4e2a\uff1a\u65b0\u589e %d \u4e2a\uff0c\u66f4\u65b0 %d \u4e2a", insertCount + updateCount, insertCount, updateCount);
    }
}

