/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.ac.pojo;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.web.ac.enums.SerialNoFormatType;
import com.kdgcsoft.web.ac.enums.SerialNoType;
import com.kdgcsoft.web.ac.enums.TransType;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

public class ModelProConfig
implements Serializable {
    public static final String SERIVAL_CODE_TEMPLATE = "{}:{}:{}:{}";
    private boolean cascadeDelete = false;
    private CacheConfig cacheConfig;
    private List<TransField> transFields;
    private List<SortField> sortFields;
    private List<SerialField> serialFields;

    public void setCascadeDelete(boolean cascadeDelete) {
        this.cascadeDelete = cascadeDelete;
    }

    public void setCacheConfig(CacheConfig cacheConfig) {
        this.cacheConfig = cacheConfig;
    }

    public void setTransFields(List<TransField> transFields) {
        this.transFields = transFields;
    }

    public void setSortFields(List<SortField> sortFields) {
        this.sortFields = sortFields;
    }

    public void setSerialFields(List<SerialField> serialFields) {
        this.serialFields = serialFields;
    }

    public boolean isCascadeDelete() {
        return this.cascadeDelete;
    }

    public CacheConfig getCacheConfig() {
        return this.cacheConfig;
    }

    public List<TransField> getTransFields() {
        return this.transFields;
    }

    public List<SortField> getSortFields() {
        return this.sortFields;
    }

    public List<SerialField> getSerialFields() {
        return this.serialFields;
    }

    public static class TransField
    implements Serializable {
        private String field;
        private TransType type;
        private String dictCode;
        private String modelCode;
        private String joinField;
        private String queryField;
        private String alias;

        public boolean isValid() {
            if (this.type == null || StrUtil.isBlank((CharSequence)this.field)) {
                return false;
            }
            if (this.type == TransType.DICT && StrUtil.isBlank((CharSequence)this.dictCode)) {
                return false;
            }
            if (this.type == TransType.MODEL && StrUtil.isBlank((CharSequence)this.modelCode)) {
                return false;
            }
            return this.type != TransType.JOIN || !StrUtil.isBlank((CharSequence)this.joinField) && !StrUtil.isBlank((CharSequence)this.queryField);
        }

        public String getAlias() {
            if (StrUtil.isNotBlank((CharSequence)this.alias)) {
                return this.alias;
            }
            return this.type == TransType.JOIN ? this.queryField : this.field + "Label";
        }

        public String joinConditionKey() {
            return StrUtil.join((CharSequence)",", (Object[])new Object[]{this.modelCode, this.field, this.joinField});
        }

        public String getField() {
            return this.field;
        }

        public TransType getType() {
            return this.type;
        }

        public String getDictCode() {
            return this.dictCode;
        }

        public String getModelCode() {
            return this.modelCode;
        }

        public String getJoinField() {
            return this.joinField;
        }

        public String getQueryField() {
            return this.queryField;
        }

        public void setField(String field) {
            this.field = field;
        }

        public void setType(TransType type) {
            this.type = type;
        }

        public void setDictCode(String dictCode) {
            this.dictCode = dictCode;
        }

        public void setModelCode(String modelCode) {
            this.modelCode = modelCode;
        }

        public void setJoinField(String joinField) {
            this.joinField = joinField;
        }

        public void setQueryField(String queryField) {
            this.queryField = queryField;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }
    }

    public static class SerialField
    implements Serializable {
        private String field;
        private SerialNoType type = SerialNoType.GLOBAL;
        private String prefix;
        private SerialNoFormatType format = SerialNoFormatType.YYYYMMDD;
        private Integer digit;
        private Long startNo;

        public String getSerialCode(String modelCode) {
            if (this.digit == null) {
                this.digit = 4;
            }
            Object typeStr = "";
            switch (this.type) {
                case GLOBAL: {
                    typeStr = SerialNoType.GLOBAL.name();
                    break;
                }
                case MODEL: {
                    typeStr = modelCode;
                    break;
                }
                case FIELD: {
                    typeStr = modelCode + "." + this.field;
                    break;
                }
                default: {
                    typeStr = SerialNoType.GLOBAL.name();
                }
            }
            String timeFormat = DateUtil.format((Date)DateUtil.date(), (String)this.format.getFormat());
            return StrUtil.format((CharSequence)ModelProConfig.SERIVAL_CODE_TEMPLATE, (Object[])new Object[]{typeStr, this.prefix, timeFormat, this.digit});
        }

        public String getField() {
            return this.field;
        }

        public SerialNoType getType() {
            return this.type;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public SerialNoFormatType getFormat() {
            return this.format;
        }

        public Integer getDigit() {
            return this.digit;
        }

        public Long getStartNo() {
            return this.startNo;
        }

        public void setField(String field) {
            this.field = field;
        }

        public void setType(SerialNoType type) {
            this.type = type;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public void setFormat(SerialNoFormatType format) {
            this.format = format;
        }

        public void setDigit(Integer digit) {
            this.digit = digit;
        }

        public void setStartNo(Long startNo) {
            this.startNo = startNo;
        }
    }

    public static class SortField
    implements Serializable {
        private String field;
        private String asc;

        public String getField() {
            return this.field;
        }

        public String getAsc() {
            return this.asc;
        }

        public void setField(String field) {
            this.field = field;
        }

        public void setAsc(String asc) {
            this.asc = asc;
        }
    }

    public static class CacheConfig
    implements Serializable {
        private boolean enable;
        private String keyField;
        private String labelField;

        public void setEnable(boolean enable) {
            this.enable = enable;
        }

        public void setKeyField(String keyField) {
            this.keyField = keyField;
        }

        public void setLabelField(String labelField) {
            this.labelField = labelField;
        }

        public boolean isEnable() {
            return this.enable;
        }

        public String getKeyField() {
            return this.keyField;
        }

        public String getLabelField() {
            return this.labelField;
        }
    }
}

