/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.ac.controller.params;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.web.ac.enums.SyncMessageLevel;
import com.kdgcsoft.web.ac.enums.SyncStatus;
import com.kdgcsoft.web.ac.enums.SyncType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SyncModelParam {
    private String syncId;
    private SyncType syncType;
    private List<String> modelIds;
    private Map<String, SyncStatus> statusMap = new HashMap<String, SyncStatus>();
    private List<SyncMessage> syncMessages = new ArrayList<SyncMessage>();
    private SyncStatus status;

    public void initStatus() {
        this.statusMap = new HashMap<String, SyncStatus>();
        this.syncMessages = new ArrayList<SyncMessage>();
        CollUtil.forEach(this.modelIds, (CollUtil.Consumer & Serializable)(modelId, index) -> this.statusMap.put((String)modelId, SyncStatus.DOING));
        this.status = SyncStatus.DOING;
    }

    public void updateModelResult(String modelId, SyncStatus status) {
        this.statusMap.put(modelId, status);
    }

    public void appendMessage(String modelId, SyncMessageLevel level, CharSequence template, Object ... params) {
        SyncMessage message = new SyncMessage();
        message.setModelId(modelId);
        message.setLevel(level);
        message.setMsg(StrUtil.format((CharSequence)template, (Object[])params));
        this.syncMessages.add(message);
    }

    public String getSyncId() {
        return this.syncId;
    }

    public SyncType getSyncType() {
        return this.syncType;
    }

    public List<String> getModelIds() {
        return this.modelIds;
    }

    public Map<String, SyncStatus> getStatusMap() {
        return this.statusMap;
    }

    public List<SyncMessage> getSyncMessages() {
        return this.syncMessages;
    }

    public SyncStatus getStatus() {
        return this.status;
    }

    public void setSyncId(String syncId) {
        this.syncId = syncId;
    }

    public void setSyncType(SyncType syncType) {
        this.syncType = syncType;
    }

    public void setModelIds(List<String> modelIds) {
        this.modelIds = modelIds;
    }

    public void setStatusMap(Map<String, SyncStatus> statusMap) {
        this.statusMap = statusMap;
    }

    public void setSyncMessages(List<SyncMessage> syncMessages) {
        this.syncMessages = syncMessages;
    }

    public void setStatus(SyncStatus status) {
        this.status = status;
    }

    public class SyncMessage {
        private String modelId;
        private SyncMessageLevel level;
        private String msg;

        public String getModelId() {
            return this.modelId;
        }

        public SyncMessageLevel getLevel() {
            return this.level;
        }

        public String getMsg() {
            return this.msg;
        }

        public void setModelId(String modelId) {
            this.modelId = modelId;
        }

        public void setLevel(SyncMessageLevel level) {
            this.level = level;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }
    }
}

