/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.ac.controller;

import cn.hutool.core.io.IoUtil;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.kdgcsoft.web.ac.entity.AcApp;
import com.kdgcsoft.web.ac.pojo.app.AppExportModel;
import com.kdgcsoft.web.ac.service.AcAppService;
import com.kdgcsoft.web.core.controller.BaseController;
import com.kdgcsoft.web.core.pojo.Result;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Resource;
import javax.validation.constraints.NotBlank;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Tag(name="\u6570\u636e\u6a21\u578b\u7ba1\u7406")
@RestController
@Validated
@RequestMapping(value={"/ac/app"})
public class AcAppController
extends BaseController {
    @Resource
    AcAppService appService;

    @Operation(summary="\u6240\u6709\u7684\u5e94\u7528\u6a21\u5757\u5217\u8868")
    @GetMapping(value={"/list"})
    public List<AcApp> list() {
        return this.appService.listApp();
    }

    @Operation(summary="\u6839\u636e\u4e3b\u952e\u83b7\u53d6\u6a21\u578b\u6570\u636e")
    @GetMapping(value={"/getById"})
    public AcApp getById(@Parameter(description="\u4e3b\u952e") @NotBlank(message="\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a") String id) {
        return this.appService.findById(id);
    }

    @Operation(summary="\u6839\u636e\u4e3b\u952e\u83b7\u53d6\u6a21\u578b\u6570\u636e")
    @GetMapping(value={"/getByCode"})
    public AcApp getByCode(@Parameter(description="\u5e94\u7528\u7f16\u7801") @NotBlank(message="\u5e94\u7528\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u5e94\u7528\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") String appCode) {
        return this.appService.findByCode(appCode);
    }

    @Operation(summary="\u4fdd\u5b58\u6570\u636e\u6a21\u578b")
    @PostMapping(value={"/save"})
    public Result save(@RequestBody @Validated AcApp acApp) {
        if (this.appService.hasRepeat(acApp)) {
            return Result.ERROR("\u5e94\u7528\u7f16\u7801\u91cd\u590d");
        }
        this.appService.saveApp(acApp);
        return Result.OK();
    }

    @Operation(summary="\u6839\u636e\u4e3b\u952e\u5220\u9664\u5e94\u7528")
    @GetMapping(value={"/deleteById"})
    public void deleteById(@Parameter(description="\u4e3b\u952e") @NotBlank(message="\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a") String appId) {
        this.appService.removeById((Serializable)((Object)appId));
    }

    @Operation(summary="\u83b7\u53d6\u6240\u6709\u5e94\u7528\u7684\u6a21\u578b\u3001\u8868\u5355\u3001\u89c6\u56fe\u3001\u6570\u636e\u96c6\u6570\u91cf")
    @GetMapping(value={"/getAppRefCount"})
    public Result getAppRefCount() {
        HashMap<String, HashMap<String, Integer>> count = this.appService.getAppRefCount();
        return Result.OK(count);
    }

    @Operation(summary="\u5bfc\u51fa\u5e94\u7528", description="\u5bfc\u51fa\u5e94\u7528\uff0c\u652f\u6301\u5355\u4e2a\u5bfc\u51fa\u548c\u6279\u91cf\u5bfc\u51fa\u3002\u5355\u4e2a\u5bfc\u51fa\u4e3a JSON \u6587\u4ef6\uff0c\u6279\u91cf\u5bfc\u51fa\u4e3a ZIP \u6587\u4ef6")
    @GetMapping(value={"/export"})
    public ResponseEntity<?> exportApp(@RequestParam String appCodes) {
        String[] appCodeList = appCodes.split(",");
        if (appCodeList.length == 1) {
            String appCode = appCodeList[0];
            String jsonName = this.appService.findByCode(appCode).getAppName();
            AppExportModel exportModel = this.appService.getExportModelByCode(appCode);
            byte[] bytes = JSON.toJSONString((Object)exportModel).getBytes(StandardCharsets.UTF_8);
            return this.renderFile(bytes, "application/json", jsonName + ".json");
        }
        if (appCodeList.length > 1) {
            ArrayList<String> jsonNameList = new ArrayList<String>();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try (ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);){
                for (String appCode : appCodeList) {
                    String jsonName = this.appService.findByCode(appCode).getAppName();
                    jsonNameList.add(jsonName);
                    AppExportModel exportModel = this.appService.getExportModelByCode(appCode);
                    byte[] bytes = JSON.toJSONString((Object)exportModel).getBytes(StandardCharsets.UTF_8);
                    ZipEntry zipEntry = new ZipEntry(jsonName + ".json");
                    zipOutputStream.putNextEntry(zipEntry);
                    zipOutputStream.write(bytes);
                    zipOutputStream.closeEntry();
                }
            }
            catch (IOException e) {
                return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
            }
            String zipName = String.join((CharSequence)"_", jsonNameList).replace(" ", "");
            return this.renderFile(byteArrayOutputStream.toByteArray(), zipName + ".zip");
        }
        return null;
    }

    @Operation(summary="\u5bfc\u5165\u5e94\u7528")
    @PostMapping(value={"/import"})
    public Result importApp(@RequestParam MultipartFile file) {
        if (file.isEmpty() || !Objects.requireNonNull(file.getOriginalFilename()).endsWith(".json")) {
            return Result.ERROR("\u8bf7\u4e0a\u4f20\u6709\u6548\u7684 .json \u6587\u4ef6.");
        }
        if (file.getSize() > 0xA00000L) {
            return Result.ERROR("\u6587\u4ef6\u5927\u5c0f\u8d85\u8fc7 10MB.");
        }
        String msg = "";
        try {
            String objStr = IoUtil.read((InputStream)file.getInputStream(), (Charset)StandardCharsets.UTF_8);
            AppExportModel exportModel = (AppExportModel)JSONObject.parseObject((String)objStr, AppExportModel.class);
            msg = this.appService.importAppInfo(exportModel);
        }
        catch (IOException e) {
            return Result.ERROR("\u6587\u4ef6\u89e3\u6790\u9519\u8bef.");
        }
        return Result.OK(msg);
    }
}

