/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.ac.controller;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.servlet.ServletUtil;
import com.alibaba.fastjson2.JSONObject;
import com.kdgcsoft.web.ac.enums.TransType;
import com.kdgcsoft.web.ac.pojo.ModelRow;
import com.kdgcsoft.web.ac.pojo.query.GridModelData;
import com.kdgcsoft.web.ac.service.AcApiModelService;
import com.kdgcsoft.web.ac.service.AcDataTransService;
import com.kdgcsoft.web.config.mvc.resolver.PageRequest;
import com.kdgcsoft.web.core.anno.AuditLog;
import com.kdgcsoft.web.core.controller.BaseController;
import com.kdgcsoft.web.core.enums.AuditLogType;
import com.kdgcsoft.web.core.pojo.Result;
import com.mybatisflex.core.paginate.Page;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotBlank;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Validated
@RequestMapping(value={"/ac/api"})
public class AcApiModelController
extends BaseController {
    @Resource
    AcApiModelService modelApiService;
    @Resource
    AcDataTransService dataTransService;

    @AuditLog(type=AuditLogType.SELECT, title="\u6839\u636eid\u83b7\u53d6\u6570\u636e\u6a21\u578b")
    @GetMapping(value={"/{modelCode}/getById"})
    public ModelRow findById(@NotBlank(message="\u6570\u636e\u6a21\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") @PathVariable(name="modelCode") @NotBlank(message="\u6570\u636e\u6a21\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") String modelCode, @NotBlank(message="\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a") String id) {
        return this.modelApiService.getById(modelCode, id);
    }

    @AuditLog(type=AuditLogType.SELECT, title="\u6839\u636e\u6307\u5b9a\u5b57\u6bb5\u83b7\u53d6\u6570\u636e")
    @GetMapping(value={"/{modelCode}/getBy/{fieldCode}/{fieldValue}"})
    public ModelRow getOneByField(@NotBlank(message="\u6570\u636e\u6a21\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") @PathVariable(name="modelCode") @NotBlank(message="\u6570\u636e\u6a21\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") String modelCode, @NotBlank(message="\u67e5\u8be2\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a") @PathVariable(name="fieldCode") @NotBlank(message="\u67e5\u8be2\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a") String fieldCode, @PathVariable(name="fieldValue") String fieldValue) {
        return this.modelApiService.getByField(modelCode, fieldCode, fieldValue);
    }

    @PostMapping(value={"/{modelCode}/save"})
    public Result save(@NotBlank(message="\u6570\u636e\u6a21\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") @PathVariable(name="modelCode") @NotBlank(message="\u6570\u636e\u6a21\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") String modelCode, @RequestBody ModelRow modelRow) {
        return this.modelApiService.save(modelCode, modelRow);
    }

    @PostMapping(value={"/{modelCode}/updateById"})
    public Result updateById(@NotBlank(message="\u6570\u636e\u6a21\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") @PathVariable(name="modelCode") @NotBlank(message="\u6570\u636e\u6a21\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") String modelCode, @RequestBody ModelRow modelRow) {
        return this.modelApiService.updateById(modelCode, modelRow);
    }

    @GetMapping(value={"/{modelCode}/deleteById"})
    public int removeById(@NotBlank(message="\u6570\u636e\u6a21\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") @PathVariable(name="modelCode") @NotBlank(message="\u6570\u636e\u6a21\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") String modelCode, @NotBlank(message="\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a") String id) {
        return this.modelApiService.deleteById(modelCode, id);
    }

    @PostMapping(value={"/{modelCode}/deleteBy"})
    public Result deleteByCondition(@NotBlank(message="\u6570\u636e\u6a21\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") @PathVariable(name="modelCode") @NotBlank(message="\u6570\u636e\u6a21\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") String modelCode, @RequestBody JSONObject params) {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        params.forEach((key, value) -> paramsMap.put((String)key, value.toString()));
        return this.modelApiService.deleteByCondition(modelCode, paramsMap);
    }

    @GetMapping(value={"/{modelCode}/page"})
    public Page<ModelRow> page(@NotBlank(message="\u6570\u636e\u6a21\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") @PathVariable(name="modelCode") @NotBlank(message="\u6570\u636e\u6a21\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") String modelCode, PageRequest<ModelRow> page, HttpServletRequest request) {
        Map paramsMap = ServletUtil.getParamMap((ServletRequest)request);
        return this.modelApiService.page(modelCode, page, paramsMap);
    }

    @PostMapping(value={"/{modelCode}/page"})
    public Page<ModelRow> page(@NotBlank(message="\u6570\u636e\u6a21\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") @PathVariable(name="modelCode") @NotBlank(message="\u6570\u636e\u6a21\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") String modelCode, PageRequest<ModelRow> page, @RequestBody Map<String, String> params) {
        return this.modelApiService.page(modelCode, page, params);
    }

    @GetMapping(value={"/{modelCode}/list"})
    public List<ModelRow> list(@NotBlank(message="\u6570\u636e\u6a21\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") @PathVariable(name="modelCode") @NotBlank(message="\u6570\u636e\u6a21\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") String modelCode, HttpServletRequest request, Integer _limit) {
        Map paramsMap = ServletUtil.getParamMap((ServletRequest)request);
        return this.modelApiService.list(modelCode, _limit, paramsMap);
    }

    @PostMapping(value={"/{modelCode}/list"})
    public List<ModelRow> list(@NotBlank(message="\u6570\u636e\u6a21\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") @PathVariable(name="modelCode") @NotBlank(message="\u6570\u636e\u6a21\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") String modelCode, @RequestBody Map<String, String> params) {
        Integer _limit = MapUtil.getInt(params, (Object)"_limit");
        return this.modelApiService.list(modelCode, _limit, params);
    }

    @GetMapping(value={"/{modelCode}/tree"})
    public List<ModelRow> tree(@NotBlank(message="\u6570\u636e\u6a21\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") @PathVariable(name="modelCode") @NotBlank(message="\u6570\u636e\u6a21\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") String modelCode, HttpServletRequest request, String pk) {
        Map paramsMap = ServletUtil.getParamMap((ServletRequest)request);
        return this.modelApiService.tree(modelCode, paramsMap, pk);
    }

    @GetMapping(value={"/{modelCode}/trans"})
    public Result trans(@NotBlank(message="\u6570\u636e\u6a21\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") @PathVariable(name="modelCode") @NotBlank(message="\u6570\u636e\u6a21\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") String modelCode, String value) {
        if (StrUtil.isBlank((CharSequence)value)) {
            return Result.OK().setData(value);
        }
        Object transResult = this.dataTransService.transValue(TransType.MODEL, modelCode, value);
        return Result.OK().setData(transResult);
    }

    @GetMapping(value={"/{modelCode}/dataPreview"})
    public GridModelData dataPreview(@NotBlank(message="\u6570\u636e\u6a21\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") @PathVariable(name="modelCode") @NotBlank(message="\u6570\u636e\u6a21\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") String modelCode, @RequestParam(value="limit", defaultValue="50") Long limit) {
        return this.modelApiService.tableDataPreview(modelCode, limit);
    }
}

