/*
 * Decompiled with CFR 0.152.
 */
package com.verhas.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommandLineProcessor {
    private final Map<String, String> options = new HashMap<String, String>();
    private final List<String> files = new ArrayList<String>();

    public Map<String, String> getOptions() {
        return this.options;
    }

    public Boolean optionExists(String name) {
        return this.getOptions().containsKey(name);
    }

    public String option(String name) {
        return this.getOptions().get(name);
    }

    public List<String> getFiles() {
        return this.files;
    }

    public void process(String[] args) {
        int i = 0;
        while (args != null && i < args.length) {
            String arg = args[i];
            if (arg.startsWith("---")) {
                this.files.add(arg.substring(2));
            } else if (arg.startsWith("--")) {
                int indexOfEqualSign = (arg = arg.substring(2)).indexOf("=");
                if (indexOfEqualSign == -1) {
                    this.options.put(arg, null);
                } else {
                    String val = arg.substring(indexOfEqualSign + 1);
                    arg = arg.substring(0, indexOfEqualSign);
                    this.options.put(arg, val);
                }
            } else if (arg.startsWith("-")) {
                arg = arg.substring(1);
                if (i + 1 < args.length) {
                    this.options.put(arg, args[i + 1]);
                } else {
                    this.options.put(arg, null);
                }
                ++i;
            } else {
                this.files.add(arg);
            }
            ++i;
        }
    }
}

