/*
 * Decompiled with CFR 0.152.
 */
package com.verhas.licensor;

import com.verhas.utils.Sugar;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bouncycastle.crypto.digests.MD5Digest;

public class HardwareBinder {
    private boolean useHostName = true;
    private boolean useNetwork = true;
    private boolean useArchitecture = true;
    private final Set<String> allowedInterfaceNames = new HashSet<String>();
    private final Set<String> deniedInterfaceNames = new HashSet<String>();

    public void ignoreHostName() {
        this.useHostName = false;
    }

    public void ignoreNetwork() {
        this.useNetwork = false;
    }

    public void ignoreArchitecture() {
        this.useArchitecture = false;
    }

    private int numberOfInterfaces() throws SocketException {
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        int interfaceCounter = 0;
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfaces.nextElement();
            if (!this.weShouldUseForTheCalculationThis(networkInterface)) continue;
            ++interfaceCounter;
        }
        return interfaceCounter;
    }

    public void interfaceAllowed(String regex) {
        this.allowedInterfaceNames.add(regex);
    }

    public void interfaceDenied(String regex) {
        this.deniedInterfaceNames.add(regex);
    }

    private boolean matchesRegexLists(NetworkInterface networkInterface) {
        String interfaceName = networkInterface.getDisplayName();
        return !Sugar.matchesAny(interfaceName, this.deniedInterfaceNames) && (this.allowedInterfaceNames.size() == 0 || Sugar.matchesAny(interfaceName, this.allowedInterfaceNames));
    }

    private boolean weShouldUseForTheCalculationThis(NetworkInterface networkInterface) throws SocketException {
        return !networkInterface.isLoopback() && !networkInterface.isVirtual() && !networkInterface.isPointToPoint() && this.matchesRegexLists(networkInterface);
    }

    private NetworkInterfaceData[] networkInterfaceData() throws SocketException {
        NetworkInterfaceData[] networkInterfaceArray = new NetworkInterfaceData[this.numberOfInterfaces()];
        int index = 0;
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfaces.nextElement();
            if (!this.weShouldUseForTheCalculationThis(networkInterface)) continue;
            networkInterfaceArray[index] = new NetworkInterfaceData(networkInterface);
            ++index;
        }
        return networkInterfaceArray;
    }

    private void sortNetworkInterfaces(NetworkInterfaceData[] networkInterfaceData) {
        Arrays.sort(networkInterfaceData, new Comparator<NetworkInterfaceData>(){

            @Override
            public int compare(NetworkInterfaceData a, NetworkInterfaceData b) {
                return a.name.compareTo(b.name);
            }
        });
    }

    private void updateWithNetworkData(MD5Digest md5, NetworkInterfaceData[] networkInterfaces) throws UnsupportedEncodingException {
        NetworkInterfaceData[] networkInterfaceDataArray = networkInterfaces;
        int n = networkInterfaces.length;
        int n2 = 0;
        while (n2 < n) {
            NetworkInterfaceData ni = networkInterfaceDataArray[n2];
            md5.update(ni.name.getBytes("utf-8"), 0, ni.name.getBytes("utf-8").length);
            if (ni.hwAddress != null) {
                md5.update(ni.hwAddress, 0, ni.hwAddress.length);
            }
            ++n2;
        }
    }

    private void updateWithNetworkData(MD5Digest md5) throws UnsupportedEncodingException, SocketException {
        NetworkInterfaceData[] networkInterfaces = this.networkInterfaceData();
        this.sortNetworkInterfaces(networkInterfaces);
        this.updateWithNetworkData(md5, networkInterfaces);
    }

    private void updateWithHostName(MD5Digest md5) throws UnknownHostException, UnsupportedEncodingException {
        String hostName = InetAddress.getLocalHost().getHostName();
        md5.update(hostName.getBytes("utf-8"), 0, hostName.getBytes("utf-8").length);
    }

    private void updateWithArchitecture(MD5Digest md5) throws UnsupportedEncodingException {
        String architectureString = System.getProperty("os.arch");
        md5.update(architectureString.getBytes("utf-8"), 0, architectureString.getBytes("utf-8").length);
    }

    public UUID getMachineId() throws UnsupportedEncodingException, SocketException, UnknownHostException {
        MD5Digest md5 = new MD5Digest();
        md5.reset();
        if (this.useNetwork) {
            this.updateWithNetworkData(md5);
        }
        if (this.useHostName) {
            this.updateWithHostName(md5);
        }
        if (this.useArchitecture) {
            this.updateWithArchitecture(md5);
        }
        byte[] digest = new byte[16];
        md5.doFinal(digest, 0);
        return UUID.nameUUIDFromBytes(digest);
    }

    public String getMachineIdString() throws UnsupportedEncodingException, SocketException, UnknownHostException {
        UUID uuid = this.getMachineId();
        if (uuid != null) {
            return uuid.toString();
        }
        return null;
    }

    public boolean assertUUID(UUID uuid) throws UnsupportedEncodingException, SocketException, UnknownHostException {
        UUID machineUUID = this.getMachineId();
        if (machineUUID == null) {
            return false;
        }
        return machineUUID.equals(uuid);
    }

    public boolean assertUUID(String uuid) {
        try {
            return this.assertUUID(UUID.fromString(uuid));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void main(String[] args) throws UnsupportedEncodingException, SocketException, UnknownHostException {
        HardwareBinder hb = new HardwareBinder();
        System.out.print(hb.getMachineIdString());
    }

    private class NetworkInterfaceData {
        String name;
        byte[] hwAddress;

        public NetworkInterfaceData(NetworkInterface networkInterface) throws SocketException {
            this.name = networkInterface.getName();
            this.hwAddress = networkInterface.getHardwareAddress();
        }
    }
}

