/*
 * Decompiled with CFR 0.152.
 */
package com.verhas.licensor;

import com.verhas.licensor.HttpHandler;
import com.verhas.licensor.License;
import java.io.IOException;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.UUID;

public class ExtendedLicense
extends License {
    private static final String EXPIRATION_DATE = "expiryDate";
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String LICENSE_ID = "licenseId";
    private static final String REVOCATION_URL = "revocationUrl";
    HttpHandler httpHandler = new HttpHandler();

    public boolean isExpired() throws ParseException {
        boolean expired;
        try {
            Date expiryDate = this.getFeature(EXPIRATION_DATE, Date.class);
            GregorianCalendar today = new GregorianCalendar();
            today.set(10, 0);
            today.set(12, 0);
            today.set(13, 0);
            today.set(14, 0);
            expired = today.getTime().after(expiryDate);
        }
        catch (Exception e) {
            expired = true;
        }
        return expired;
    }

    public void setExpiry(Date expiryDate) {
        this.setFeature(EXPIRATION_DATE, expiryDate);
    }

    public UUID generateLicenseId() {
        UUID uuid = UUID.randomUUID();
        this.setLicenseId(uuid);
        return uuid;
    }

    public void setLicenseId(UUID licenseId) {
        this.setFeature(LICENSE_ID, licenseId);
    }

    public UUID getLicenseId() {
        UUID licenseId = null;
        try {
            licenseId = this.getFeature(LICENSE_ID, UUID.class);
        }
        catch (Exception e) {
            licenseId = null;
        }
        return licenseId;
    }

    public void setFeature(String name, Integer i) {
        this.setFeature(name, i.toString());
    }

    public void setFeature(String name, Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT);
        this.setFeature(name, formatter.format(date));
    }

    public void setFeature(String name, URL url) {
        this.setFeature(name, url.toString());
    }

    public void setFeature(String name, UUID uuid) {
        this.setFeature(name, uuid.toString());
    }

    public <T> T getFeature(String name, Class<? extends T> klass) throws InstantiationException, IllegalAccessException, ParseException, MalformedURLException {
        Serializable result = null;
        String resultString = this.getFeature(name);
        if (Integer.class == klass) {
            result = Integer.parseInt(resultString);
        } else if (Date.class == klass) {
            result = new SimpleDateFormat(DATE_FORMAT).parse(this.getFeature(name));
        } else if (UUID.class == klass) {
            result = UUID.fromString(this.getFeature(name));
        } else if (URL.class == klass) {
            result = new URL(this.getFeature(name));
        } else {
            throw new IllegalArgumentException("'" + klass.toString() + "' is not handled");
        }
        return (T)result;
    }

    public URL getRevocationURL() throws MalformedURLException {
        URL url = null;
        String revocationURLTemplate = this.getFeature(REVOCATION_URL);
        if (revocationURLTemplate != null) {
            UUID licenseId = this.getLicenseId();
            String revocationURL = licenseId != null ? revocationURLTemplate.replaceAll("\\$\\{licenseId\\}", licenseId.toString()) : revocationURLTemplate;
            url = new URL(revocationURL);
        }
        return url;
    }

    public void setRevocationURL(String url) {
        this.setFeature(REVOCATION_URL, url);
    }

    public void setRevocationURL(URL url) {
        this.setRevocationURL(url.toString());
    }

    public boolean isRevoked() {
        return this.isRevoked(false);
    }

    public boolean isRevoked(boolean defaultRevocationState) {
        boolean revoked = true;
        try {
            URL url = this.getRevocationURL();
            if (url != null) {
                URLConnection connection = this.httpHandler.openConnection(url);
                connection.setUseCaches(false);
                if (connection instanceof HttpURLConnection) {
                    connection.connect();
                    HttpURLConnection httpUrlConnection = (HttpURLConnection)connection;
                    int responseCode = this.httpHandler.getResponseCode(httpUrlConnection);
                    if (responseCode == 200) {
                        revoked = false;
                    }
                }
            } else {
                revoked = false;
            }
        }
        catch (IOException exception) {
            revoked = defaultRevocationState;
        }
        return revoked;
    }
}

